/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.util;

import com.couchbase.client.core.util.IntMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;

class CompactIntMap<E>
implements IntMap<E> {
    static final int MAX_WASTED_ARRAY_ELEMENTS = 1024;
    private static final IntMap<?> EMPTY = new CompactIntMap(new Object[0]);
    private final E[] indexToValue;

    static <E> IntMap<E> empty() {
        return EMPTY;
    }

    CompactIntMap(Object[] indexToValue) {
        this.indexToValue = indexToValue;
    }

    @Override
    public @Nullable E get(int key) {
        try {
            if (key >= this.indexToValue.length) {
                return null;
            }
            return this.indexToValue[key];
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("key must be non-negative, but got " + key);
        }
    }

    private Map<Integer, E> toMap() {
        LinkedHashMap<Integer, E> result = new LinkedHashMap<Integer, E>();
        for (int i = 0; i < this.indexToValue.length; ++i) {
            if (this.get(i) == null) continue;
            result.put(i, this.get(i));
        }
        return result;
    }

    public String toString() {
        return "CompactIntMap" + this.toMap();
    }
}

