/*
 * Copyright (c) 2023 Couchbase, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.couchbase.client.core.api.search;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.kv.CoreAsyncResponse;
import com.couchbase.client.core.api.search.queries.CoreSearchRequest;
import com.couchbase.client.core.api.search.result.CoreReactiveSearchResult;
import com.couchbase.client.core.api.search.result.CoreSearchResult;
import reactor.core.publisher.Mono;

@Stability.Internal
public interface CoreSearchOps {
  CoreAsyncResponse<CoreSearchResult> searchQueryAsync(String indexName,
                                                       CoreSearchQuery query,
                                                       CoreSearchOptions options);

  Mono<CoreReactiveSearchResult> searchQueryReactive(String indexName,
                                                     CoreSearchQuery query,
                                                     CoreSearchOptions options);

  CoreAsyncResponse<CoreSearchResult> searchAsync(String indexName,
                                                  CoreSearchRequest searchRequest,
                                                  CoreSearchOptions options);

  Mono<CoreReactiveSearchResult> searchReactive(String indexName,
                                                CoreSearchRequest searchRequest,
                                                CoreSearchOptions options);
}
