/*
 * Copyright (c) 2018 Couchbase, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.couchbase.client.core.env;

import java.util.function.Supplier;

/**
 * This supplier signals the entity passed in is not owned.
 * <p>
 * This class can be used with care, but usually it is better to just use the java 8 supplier interface directly
 * or implement your own.
 *
 * @deprecated Please use {@link Supplier} instead.
 * In internal Couchbase code, please use {@link OwnedOrExternal#external(Object)} instead.
 */
@Deprecated
public class ExternalSupplier<T> implements Supplier<T> {

  private final T value;

  public ExternalSupplier(final T value) {
    this.value = value;
  }

  @Override
  public T get() {
    return value;
  }

  @Override
  public String toString() {
    return "ExternalSupplier{" + value + '}';
  }

}
