/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.topology;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.topology.AbstractBucketTopology;
import com.couchbase.client.core.topology.BucketCapability;
import com.couchbase.client.core.topology.HostAndServicePorts;
import com.couchbase.client.core.topology.NodeIdentifier;
import com.couchbase.client.core.topology.PartitionMap;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;

@Stability.Internal
public class CouchbaseBucketTopology
extends AbstractBucketTopology {
    static final int PARTITION_NOT_EXISTENT = -2;
    private final boolean ephemeral;
    private final int replicas;
    private final PartitionMap partitions;
    private final Optional<PartitionMap> partitionsForward;
    private final Set<NodeIdentifier> primaryPartitionNodeIds;

    public CouchbaseBucketTopology(String name, String uuid, Set<BucketCapability> capabilities, List<HostAndServicePorts> nodes, boolean ephemeral, int replicas, PartitionMap partitions, @Nullable PartitionMap partitionsForward) {
        super(name, uuid, capabilities, nodes);
        this.replicas = replicas;
        this.partitions = Objects.requireNonNull(partitions);
        this.partitionsForward = Optional.ofNullable(partitionsForward);
        this.ephemeral = ephemeral;
        this.primaryPartitionNodeIds = Collections.unmodifiableSet(partitions.values().stream().map(it -> it.active().map(HostAndServicePorts::id).orElse(null)).filter(Objects::nonNull).collect(Collectors.toSet()));
    }

    public boolean ephemeral() {
        return this.ephemeral;
    }

    public int numberOfPartitions() {
        return this.partitions.size();
    }

    public int numberOfReplicas() {
        return this.replicas;
    }

    public PartitionMap partitions() {
        return this.partitions;
    }

    public Optional<PartitionMap> partitionsForward() {
        return this.partitionsForward;
    }

    private PartitionMap partitions(boolean forward) {
        return forward ? this.partitionsForward().orElseThrow(() -> new IllegalStateException("Config has no forward partition map.")) : this.partitions();
    }

    public boolean hasPrimaryPartitionsOnNode(NodeIdentifier id) {
        return this.primaryPartitionNodeIds.contains(id);
    }

    @Deprecated
    public int nodeIndexForActive(int partition, boolean forward) {
        return this.partitions(forward).get(partition).nodeIndexForActive().orElse(-2);
    }

    @Deprecated
    public int nodeIndexForReplica(int partition, int replica, boolean forward) {
        return this.partitions(forward).get(partition).nodeIndexForReplica(replica).orElse(-2);
    }

    public String toString() {
        return "CouchbaseBucketTopology{name='" + RedactableArgument.redactMeta(this.name()) + '\'' + ", uuid='" + this.uuid() + '\'' + ", ephemeral=" + this.ephemeral + ", capabilities=" + this.capabilities() + ", replicas=" + this.replicas + ", partitions=" + this.partitions + ", partitionsForward=" + this.partitionsForward + '}';
    }
}

