/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.util;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.util.CbCollections;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.jspecify.annotations.Nullable;

@Stability.Internal
public class AtomicEnumSet<E extends Enum<E>>
extends AbstractSet<E> {
    private final AtomicLong bits = new AtomicLong();
    private final Class<E> enumClass;
    private final List<E> allValues;

    private AtomicEnumSet(Class<E> enumClass) {
        this.enumClass = Objects.requireNonNull(enumClass);
        this.allValues = CbCollections.listCopyOf(EnumSet.allOf(enumClass));
        long numValues = this.allValues.size();
        if (numValues > 64L) {
            throw new IllegalArgumentException(enumClass + " has too many enum values to store in this kind of set.");
        }
    }

    public static <E extends Enum<E>> AtomicEnumSet<E> noneOf(Class<E> enumClass) {
        return new AtomicEnumSet<E>(enumClass);
    }

    public static <E extends Enum<E>> AtomicEnumSet<E> allOf(Class<E> enumClass) {
        AtomicEnumSet<E> set = AtomicEnumSet.noneOf(enumClass);
        set.addAll(set.allValues);
        return set;
    }

    @Override
    public boolean contains(@Nullable Object value) {
        if (value == null) {
            return false;
        }
        try {
            Enum e = (Enum)value;
            return (this.bits.get() & this.mask(e)) != 0L;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Objects.requireNonNull(c);
        try {
            long mask = 0L;
            for (Object value : c) {
                Enum e = (Enum)value;
                mask |= this.mask(e);
            }
            return (this.bits.get() & mask) == mask;
        }
        catch (ClassCastException | NullPointerException e) {
            return false;
        }
    }

    @Override
    public boolean add(E value) {
        return this.setBits(this.mask(value));
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.setBits(this.mask(c, MaskMode.REJECT_NULLS));
    }

    @Override
    public boolean remove(Object value) {
        if (!this.enumClass.isInstance(value)) {
            return false;
        }
        long mask = this.mask((Enum)value);
        return this.clearBits(mask);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.clearBits(this.mask(c, MaskMode.ACCEPT_NULLS));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.clearBits(this.mask(c, MaskMode.ACCEPT_NULLS) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public Iterator<E> iterator() {
        long snapshot = this.bits.get();
        return this.allValues.stream().filter(value -> (snapshot & this.mask(value)) != 0L).iterator();
    }

    @Override
    public int size() {
        return Long.bitCount(this.bits.get());
    }

    @Override
    public boolean isEmpty() {
        return this.bits.get() == 0L;
    }

    @Override
    public void clear() {
        this.bits.set(0L);
    }

    private long mask(E value) {
        return 1L << ((Enum)value).ordinal();
    }

    private long mask(Iterable<?> values, MaskMode mode) {
        long mask = 0L;
        for (Object value : values) {
            if (this.enumClass.isInstance(value)) {
                Enum e = (Enum)value;
                mask |= this.mask(e);
                continue;
            }
            if (mode != MaskMode.REJECT_NULLS) continue;
            Objects.requireNonNull(value);
        }
        return mask;
    }

    private boolean setBits(long mask) {
        long old = this.bits.getAndUpdate(bits -> bits | mask);
        return (old & mask) != mask;
    }

    private boolean clearBits(long mask) {
        long old = this.bits.getAndUpdate(bits -> bits & (mask ^ 0xFFFFFFFFFFFFFFFFL));
        return (old & mask) != 0L;
    }

    private static enum MaskMode {
        ACCEPT_NULLS,
        REJECT_NULLS;

    }
}

