/*
 * Copyright (c) 2017-2022 VMware Inc. or its affiliates, All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * THIS FILE HAS BEEN MODIFIED FROM THE ORIGINAL VERSION.
 * Changes by Couchbase:
 *
 * - Removed constructors not required by Couchbase SDK.
 * - Modified deprecation notice to not refer to a specific Reactor Addons version.
 */

package com.couchbase.client.core.retry.reactor;

/**
 * Exception indicating that retries have been exhausted after
 * {@link Retry#timeout(java.time.Duration)} or {@link Retry#retryMax(long)}.
 * For retries, {@link #getCause()} returns the original exception from the
 * last retry attempt that generated this exception.
 * @deprecated Use equivalent features of reactor-core like
 * {@link reactor.core.Exceptions#retryExhausted(String, Throwable)} and {@link reactor.core.Exceptions#isRetryExhausted(Throwable)} instead.
 */
@Deprecated
public class RetryExhaustedException extends RuntimeException {

	private static final long serialVersionUID = 6961442923363481283L;

	public RetryExhaustedException(String message) {
		super(message);
	}

	public RetryExhaustedException(Throwable cause) {
		super(cause);
	}
}
