/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.search.queries;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.search.CoreSearchQuery;
import com.couchbase.client.core.api.search.queries.CoreGeoPoint;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ArrayNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.protostellar.CoreProtostellarUtil;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.protostellar.search.v1.GeoPolygonQuery;
import com.couchbase.client.protostellar.search.v1.Query;
import java.util.List;
import java.util.stream.Collectors;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class CoreGeoPolygonQuery
extends CoreSearchQuery {
    private final List<? extends CoreGeoPoint> coordinates;
    @Nullable
    private final String field;

    public CoreGeoPolygonQuery(List<? extends CoreGeoPoint> coordinates, @Nullable String field, @Nullable Double boost) {
        super(boost);
        this.coordinates = Validators.notNullOrEmpty(coordinates, "GeoPolygonQuery Coordinates");
        this.field = field;
    }

    @Override
    protected void injectParams(ObjectNode input) {
        ArrayNode points = Mapper.createArrayNode();
        this.coordinates.forEach(c -> {
            ArrayNode coords = Mapper.createArrayNode();
            coords.add(c.toJson());
            points.add(coords);
        });
        input.set("polygon_points", points);
        if (this.field != null) {
            input.put("field", this.field);
        }
    }

    @Override
    public Query asProtostellar() {
        GeoPolygonQuery.Builder builder = GeoPolygonQuery.newBuilder().addAllVertices(this.coordinates.stream().map(CoreProtostellarUtil::toLatLng).collect(Collectors.toList()));
        if (this.field != null) {
            builder.setField(this.field);
        }
        if (this.boost != null) {
            builder.setBoost(this.boost.floatValue());
        }
        return Query.newBuilder().setGeoPolygonQuery(builder).build();
    }
}

