/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.cnc;

import com.couchbase.client.core.cnc.Context;
import com.couchbase.client.core.cnc.Event;
import com.couchbase.client.core.env.LoggerConfig;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.msg.RequestContext;
import com.couchbase.client.core.util.CbCollections;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class LoggingEventConsumer
implements Consumer<Event> {
    private final Map<String, Logger> loggers = new HashMap<String, Logger>(Event.Category.values().length);
    private final LoggerConfig loggerConfig;

    public static LoggingEventConsumer create() {
        return new LoggingEventConsumer(LoggerConfig.create());
    }

    public static LoggingEventConsumer create(LoggerConfig loggerConfig) {
        return new LoggingEventConsumer(loggerConfig);
    }

    private LoggingEventConsumer(LoggerConfig loggerConfig) {
        this.loggerConfig = loggerConfig;
    }

    @Override
    public void accept(Event event) {
        boolean diagnosticContext;
        String description;
        Event.Severity severity = event.severity();
        if (severity == Event.Severity.TRACING) {
            return;
        }
        Logger logger = this.loggers.computeIfAbsent(event.category(), LoggerFactory::getLogger);
        if (!LoggingEventConsumer.mustLogEvent(severity, logger)) {
            return;
        }
        StringBuilder logLineBuilder = new StringBuilder();
        logLineBuilder.append("[").append(event.category()).append("]");
        logLineBuilder.append("[").append(event.getClass().getSimpleName()).append("]");
        if (!event.duration().isZero()) {
            logLineBuilder.append("[").append(LoggingEventConsumer.convertEventDuration(event.duration())).append("]");
        }
        if ((description = event.description()) != null && !description.isEmpty()) {
            logLineBuilder.append(" ").append(description);
        }
        if (event.context() != null) {
            logLineBuilder.append(" ").append(event.context().exportAsString(Context.ExportFormat.JSON));
        }
        String logLine = logLineBuilder.toString();
        boolean bl = diagnosticContext = this.loggerConfig.diagnosticContextEnabled() && event.context() instanceof RequestContext;
        if (diagnosticContext) {
            LoggingEventConsumer.attachContext(((RequestContext)event.context()).clientContext());
        }
        switch (severity) {
            case VERBOSE: {
                if (event.cause() != null) {
                    logger.trace("{}", (Object)logLine, (Object)event.cause());
                    break;
                }
                logger.trace("{}", (Object)logLine);
                break;
            }
            case DEBUG: {
                if (event.cause() != null) {
                    logger.debug("{}", (Object)logLine, (Object)event.cause());
                    break;
                }
                logger.debug("{}", (Object)logLine);
                break;
            }
            case INFO: {
                if (event.cause() != null) {
                    logger.info("{}", (Object)logLine, (Object)event.cause());
                    break;
                }
                logger.info("{}", (Object)logLine);
                break;
            }
            case WARN: {
                if (event.cause() != null) {
                    logger.warn("{}", (Object)logLine, (Object)event.cause());
                    break;
                }
                logger.warn("{}", (Object)logLine);
                break;
            }
            case ERROR: {
                if (event.cause() != null) {
                    logger.error("{}", (Object)logLine, (Object)event.cause());
                    break;
                }
                logger.error("{}", (Object)logLine);
            }
        }
        if (diagnosticContext) {
            MDC.clear();
        }
    }

    private static void attachContext(Map<String, Object> context) {
        if (CbCollections.isNullOrEmpty(context)) {
            return;
        }
        MDC.setContextMap(context.entrySet().stream().collect(Collectors.toMap(e -> RedactableArgument.redactUser(e.getKey()).toString(), e -> {
            Object v = e.getValue();
            return v == null ? "" : RedactableArgument.redactUser(v.toString()).toString();
        })));
    }

    private static boolean mustLogEvent(Event.Severity severity, Logger logger) {
        switch (severity) {
            case VERBOSE: {
                return logger.isTraceEnabled();
            }
            case DEBUG: {
                return logger.isDebugEnabled();
            }
            case INFO: {
                return logger.isInfoEnabled();
            }
            case WARN: {
                return logger.isWarnEnabled();
            }
            case ERROR: {
                return logger.isErrorEnabled();
            }
        }
        return true;
    }

    static String convertEventDuration(Duration duration) {
        long nanos = duration.toNanos();
        if (nanos < 1000L) {
            return nanos + "ns";
        }
        if (nanos < 10000000L) {
            return TimeUnit.NANOSECONDS.toMicros(nanos) + "us";
        }
        if (nanos < 10000000000L) {
            return TimeUnit.NANOSECONDS.toMillis(nanos) + "ms";
        }
        return TimeUnit.NANOSECONDS.toSeconds(nanos) + "s";
    }
}

