/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.cnc.events.io;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.AbstractEvent;
import com.couchbase.client.core.cnc.Context;
import com.couchbase.client.core.cnc.Event;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBufUtil;
import com.couchbase.client.core.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.core.io.IoContext;
import java.time.Duration;
import java.util.Objects;

@Stability.Internal
public class UnknownServerPushRequestReceivedEvent
extends AbstractEvent {
    private final byte[] request;

    public UnknownServerPushRequestReceivedEvent(IoContext context, byte[] request) {
        super(Event.Severity.WARN, Event.Category.IO, Duration.ZERO, (Context)context);
        this.request = Objects.requireNonNull(request);
    }

    public byte[] request() {
        return this.request;
    }

    @Override
    public String description() {
        return "Received a server push request with an unsupported opcode: \n" + ByteBufUtil.prettyHexDump(Unpooled.wrappedBuffer(this.request)) + "\n";
    }
}

