/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.cnc.metrics;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.Meter;
import com.couchbase.client.core.cnc.metrics.CounterName;
import com.couchbase.client.core.cnc.metrics.LoggingMeter;
import com.couchbase.client.core.cnc.metrics.MeterProviderImpl;
import com.couchbase.client.core.cnc.metrics.MeterProviderImplV0;
import com.couchbase.client.core.cnc.metrics.MeterProviderImplV1;
import com.couchbase.client.core.cnc.metrics.NoopMeter;
import com.couchbase.client.core.cnc.metrics.ResponseMetricIdentifier;
import com.couchbase.client.core.cnc.metrics.ValueRecorderName;
import com.couchbase.client.core.cnc.metrics.WrappedCounter;
import com.couchbase.client.core.cnc.metrics.WrappedValueRecorder;
import com.couchbase.client.core.cnc.tracing.ObservabilitySemanticConvention;
import java.util.List;
import java.util.Objects;

@Stability.Internal
public class AbstractMeter {
    private final MeterProviderImpl v0;
    private final MeterProviderImpl v1;
    private final boolean useV0;
    private final boolean useV1;
    private final Meter originalMeter;

    public AbstractMeter(Meter originalMeter, List<ObservabilitySemanticConvention> conventions) {
        Objects.requireNonNull(conventions);
        this.originalMeter = Objects.requireNonNull(originalMeter);
        if (conventions.isEmpty()) {
            this.useV0 = true;
            this.useV1 = false;
        } else if (conventions.contains((Object)ObservabilitySemanticConvention.DATABASE_DUP)) {
            this.useV0 = true;
            this.useV1 = true;
        } else if (conventions.contains((Object)ObservabilitySemanticConvention.DATABASE)) {
            this.useV0 = false;
            this.useV1 = true;
        } else {
            throw new IllegalArgumentException("Unknown observability convention: " + conventions);
        }
        this.v0 = new MeterProviderImplV0(originalMeter);
        this.v1 = new MeterProviderImplV1(originalMeter);
    }

    public WrappedCounter counter(CounterName metric, ResponseMetricIdentifier rmi) {
        WrappedCounter counters = new WrappedCounter();
        if (this.useV0) {
            counters.add(this.v0.counter(metric, rmi));
        }
        if (this.useV1) {
            counters.add(this.v1.counter(metric, rmi));
        }
        return counters;
    }

    public WrappedValueRecorder valueRecorder(ValueRecorderName metric, ResponseMetricIdentifier rmi) {
        WrappedValueRecorder valueRecorders = new WrappedValueRecorder();
        if (this.useV0) {
            valueRecorders.add(this.v0.valueRecorder(metric, rmi));
        }
        if (this.useV1) {
            valueRecorders.add(this.v1.valueRecorder(metric, rmi));
        }
        return valueRecorders;
    }

    public boolean isDefaultLoggingMeter() {
        return this.originalMeter instanceof LoggingMeter;
    }

    public boolean isNoopMeter() {
        return this.originalMeter instanceof NoopMeter;
    }
}

