/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.io.netty.kv.sasl;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.env.SaslMechanism;
import com.couchbase.client.core.io.netty.kv.sasl.CallbackHelper;
import com.couchbase.client.core.io.netty.kv.sasl.InitialResponseSaslClient;
import java.nio.charset.StandardCharsets;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@Stability.Internal
@NullMarked
public class OauthBearerSaslClient
extends InitialResponseSaslClient {
    public OauthBearerSaslClient(@Nullable String authorizationId, CallbackHandler callbackHandler) {
        super(authorizationId, callbackHandler);
    }

    @Override
    public String getMechanismName() {
        return SaslMechanism.OAUTHBEARER.mech();
    }

    @Override
    protected byte[] getInitialResponse(CallbackHandler callbackHandler) throws SaslException {
        String authorizationComponent = this.authorizationId == null ? "" : "a=" + this.authorizationId;
        String token = CallbackHelper.getPassword(callbackHandler);
        return ("n," + authorizationComponent + ",\u0001auth=Bearer " + token + "\u0001\u0001").getBytes(StandardCharsets.UTF_8);
    }
}

