/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.manager;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.manager.CoreBucketAndScope;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.cnc.tracing.TracingAttribute;
import com.couchbase.client.core.cnc.tracing.TracingDecorator;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ArrayNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.endpoint.http.CoreHttpClient;
import com.couchbase.client.core.endpoint.http.CoreHttpPath;
import com.couchbase.client.core.endpoint.http.CoreHttpResponse;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.msg.RequestTarget;
import com.couchbase.client.core.util.UrlQueryStringBuilder;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class CoreEventingFunctionManager {
    private static final String V1 = "/api/v1";
    private final Core core;
    @Nullable
    private final CoreBucketAndScope scope;
    private final CoreHttpClient httpClient;
    private static final CoreBucketAndScope ADMIN_SCOPE = new CoreBucketAndScope("*", "*");

    public CoreEventingFunctionManager(Core core) {
        this(core, null);
    }

    public CoreEventingFunctionManager(Core core, @Nullable CoreBucketAndScope scope) {
        this.core = Objects.requireNonNull(core);
        this.scope = scope;
        this.httpClient = core.httpClient(RequestTarget.eventing());
    }

    private static String pathForFunctions() {
        return "/api/v1/functions";
    }

    private static String pathForFunction(String name) {
        return CoreEventingFunctionManager.pathForFunctions() + "/" + UrlQueryStringBuilder.urlEncode(name);
    }

    private static String pathForDeploy(String name) {
        return CoreEventingFunctionManager.pathForFunction(name) + "/deploy";
    }

    private static String pathForUndeploy(String name) {
        return CoreEventingFunctionManager.pathForFunction(name) + "/undeploy";
    }

    private static String pathForResume(String name) {
        return CoreEventingFunctionManager.pathForFunction(name) + "/resume";
    }

    private static String pathForPause(String name) {
        return CoreEventingFunctionManager.pathForFunction(name) + "/pause";
    }

    private static String pathForStatus() {
        return "/api/v1/status";
    }

    private CoreHttpPath scopedPath(String template) {
        if (this.scope != null) {
            template = template + CoreHttpPath.formatPath("?bucket={}&scope={}", this.scope.bucketName(), this.scope.scopeName());
        }
        return CoreHttpPath.path(template);
    }

    private void setSpanAttributes(RequestSpan span) {
        TracingDecorator tip = this.core.coreResources().tracingDecorator();
        tip.provideLowCardinalityAttr(TracingAttribute.BUCKET_NAME, span, this.scope == null ? "*" : this.scope.bucketName());
        tip.provideAttr(TracingAttribute.SCOPE_NAME, span, this.scope == null ? "*" : this.scope.scopeName());
    }

    public CompletableFuture<Void> upsertFunction(String name, byte[] function, CoreCommonOptions options) {
        function = this.injectScope(function);
        return this.httpClient.post(this.scopedPath(CoreEventingFunctionManager.pathForFunction(name)), options).json(function).trace("manager_eventing_upsert_function", this::setSpanAttributes).build().exec(this.core).thenApply(response -> null);
    }

    private byte[] injectScope(byte[] function) {
        if (this.scope == null) {
            return function;
        }
        ObjectNode node = Mapper.decodeInto(function, ObjectNode.class);
        node.set("function_scope", Mapper.createObjectNode().put("bucket", this.scope.bucketName()).put("scope", this.scope.scopeName()));
        return Mapper.encodeAsBytes(node);
    }

    public CompletableFuture<Void> dropFunction(String name, CoreCommonOptions options) {
        return this.httpClient.delete(this.scopedPath(CoreEventingFunctionManager.pathForFunction(name)), options).trace("manager_eventing_drop_function", this::setSpanAttributes).build().exec(this.core).thenApply(response -> null);
    }

    public CompletableFuture<Void> deployFunction(String name, CoreCommonOptions options) {
        return this.httpClient.post(this.scopedPath(CoreEventingFunctionManager.pathForDeploy(name)), options).trace("manager_eventing_deploy_function", this::setSpanAttributes).build().exec(this.core).thenApply(response -> null);
    }

    public CompletableFuture<byte[]> getAllFunctions(CoreCommonOptions options) {
        return this.httpClient.get(CoreHttpPath.path(CoreEventingFunctionManager.pathForFunctions()), options).trace("manager_eventing_get_all_functions", this::setSpanAttributes).build().exec(this.core).thenApply(response -> this.filterGetAllFunctionsResponse(response.content()));
    }

    private byte[] filterGetAllFunctionsResponse(byte[] input) {
        ArrayNode node = Mapper.decodeInto(input, ArrayNode.class);
        this.applyScopeFilter(node);
        return Mapper.encodeAsBytes(node);
    }

    public CompletableFuture<byte[]> getFunction(String name, CoreCommonOptions options) {
        return this.httpClient.get(this.scopedPath(CoreEventingFunctionManager.pathForFunction(name)), options).trace("manager_eventing_get_function", this::setSpanAttributes).build().exec(this.core).thenApply(CoreHttpResponse::content);
    }

    public CompletableFuture<Void> pauseFunction(String name, CoreCommonOptions options) {
        return this.httpClient.post(this.scopedPath(CoreEventingFunctionManager.pathForPause(name)), options).trace("manager_eventing_pause_function", this::setSpanAttributes).build().exec(this.core).thenApply(response -> null);
    }

    public CompletableFuture<Void> resumeFunction(String name, CoreCommonOptions options) {
        return this.httpClient.post(this.scopedPath(CoreEventingFunctionManager.pathForResume(name)), options).trace("manager_eventing_resume_function", this::setSpanAttributes).build().exec(this.core).thenApply(response -> null);
    }

    public CompletableFuture<Void> undeployFunction(String name, CoreCommonOptions options) {
        return this.httpClient.post(this.scopedPath(CoreEventingFunctionManager.pathForUndeploy(name)), options).trace("manager_eventing_undeploy_function", this::setSpanAttributes).build().exec(this.core).thenApply(response -> null);
    }

    public CompletableFuture<byte[]> functionsStatus(CoreCommonOptions options) {
        return this.httpClient.get(CoreHttpPath.path(CoreEventingFunctionManager.pathForStatus()), options).trace("manager_eventing_functions_status", this::setSpanAttributes).build().exec(this.core).thenApply(response -> this.filterFunctionStatusResponse(response.content()));
    }

    private byte[] filterFunctionStatusResponse(byte[] input) {
        JsonNode node = Mapper.decodeIntoTree(input);
        this.applyScopeFilter((ArrayNode)node.get("apps"));
        return Mapper.encodeAsBytes(node);
    }

    private void applyScopeFilter(@Nullable ArrayNode array) {
        if (array == null) {
            return;
        }
        Iterator<JsonNode> i = array.iterator();
        while (i.hasNext()) {
            JsonNode element = i.next();
            JsonNode scopeNode = element.get("function_scope");
            if (Objects.equals(this.scope, CoreEventingFunctionManager.parseScope(scopeNode))) continue;
            i.remove();
        }
    }

    @Nullable
    private static CoreBucketAndScope parseScope(@Nullable JsonNode node) {
        if (node == null) {
            return null;
        }
        CoreBucketAndScope result = new CoreBucketAndScope(node.path("bucket").asText(), node.path("scope").asText());
        return result.equals(ADMIN_SCOPE) ? null : result;
    }
}

