/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.kv;

import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.cnc.tracing.TracingAttribute;
import com.couchbase.client.core.cnc.tracing.TracingDecorator;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import java.util.Optional;

public interface SyncDurabilityRequest {
    public Optional<DurabilityLevel> durabilityLevel();

    default public void applyLevelOnSpan(Optional<DurabilityLevel> level, RequestSpan span, TracingDecorator tip) {
        if (level.isPresent() && span != null) {
            switch (level.get()) {
                case MAJORITY: {
                    tip.provideLowCardinalityAttr(TracingAttribute.DURABILITY, span, "majority");
                    break;
                }
                case MAJORITY_AND_PERSIST_TO_ACTIVE: {
                    tip.provideLowCardinalityAttr(TracingAttribute.DURABILITY, span, "majority_and_persist_active");
                    break;
                }
                case PERSIST_TO_MAJORITY: {
                    tip.provideLowCardinalityAttr(TracingAttribute.DURABILITY, span, "persist_majority");
                }
            }
        }
    }
}

