/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.protostellar;

import com.couchbase.client.core.CoreKeyspace;
import com.couchbase.client.core.CoreProtostellar;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.kv.CoreDurability;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.core.protostellar.ProtostellarRequest;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.service.ServiceType;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;

@Stability.Internal
public class ProtostellarKeyValueRequest<TGrpcRequest>
extends ProtostellarRequest<TGrpcRequest> {
    public ProtostellarKeyValueRequest(TGrpcRequest request, CoreProtostellar core, CoreKeyspace keyspace, String key, CoreDurability durability, String requestName, RequestSpan span, Duration timeout, boolean readonly, RetryStrategy retryStrategy, Map<String, Object> clientContext, long encodeDurationNanos) {
        super(request, core, ServiceType.KV, requestName, span, timeout, readonly, retryStrategy, clientContext, encodeDurationNanos, ctx -> {
            HashMap<String, String> service = new HashMap<String, String>();
            service.put("type", ServiceType.KV.ident());
            ctx.put("service", service);
            if (keyspace != null) {
                ctx.put("bucket", RedactableArgument.redactMeta(keyspace.bucket()));
                ctx.put("scope", RedactableArgument.redactMeta(keyspace.scope()));
                ctx.put("collection", RedactableArgument.redactMeta(keyspace.collection()));
            }
            if (key != null) {
                ctx.put("documentId", RedactableArgument.redactUser(key));
            }
            if (!durability.isLegacy() && !durability.isNone()) {
                ctx.put("syncDurability", durability.levelIfSynchronous().orElse(DurabilityLevel.NONE).encodeForManagementApi());
            }
        });
    }
}

