/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.service;

import com.couchbase.client.core.service.ServiceScope;
import java.util.Objects;

public enum ServiceType {
    KV(ServiceScope.BUCKET, "kv"),
    QUERY(ServiceScope.CLUSTER, "query"),
    ANALYTICS(ServiceScope.CLUSTER, "analytics"),
    SEARCH(ServiceScope.CLUSTER, "search"),
    VIEWS(ServiceScope.CLUSTER, "views"),
    MANAGER(ServiceScope.CLUSTER, "management", "mgmt"),
    EVENTING(ServiceScope.CLUSTER, "eventing"),
    BACKUP(ServiceScope.CLUSTER, "backup");

    private final ServiceScope scope;
    private final String id;
    private final String ident;

    private ServiceType(ServiceScope scope, String id) {
        this(scope, id, id);
    }

    private ServiceType(ServiceScope scope, String id, String ident) {
        this.scope = Objects.requireNonNull(scope);
        this.id = Objects.requireNonNull(id);
        this.ident = Objects.requireNonNull(ident);
    }

    public ServiceScope scope() {
        return this.scope;
    }

    @Deprecated
    public String ident() {
        return this.ident;
    }

    public String id() {
        return this.id;
    }
}

