/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.codec;

import com.couchbase.client.core.error.DecodingFailureException;
import com.couchbase.client.core.error.EncodingFailureException;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.codec.TypeRef;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.json.JsonMapper;

public class Jackson3JsonSerializer
implements JsonSerializer {
    private final JsonMapper mapper;

    public static Jackson3JsonSerializer create(JsonMapper mapper) {
        return new Jackson3JsonSerializer(mapper);
    }

    private Jackson3JsonSerializer(JsonMapper mapper) {
        this.mapper = Objects.requireNonNull(mapper);
    }

    @Override
    public byte[] serialize(Object input) {
        if (input instanceof byte[]) {
            return (byte[])input;
        }
        try {
            return this.mapper.writeValueAsBytes(input);
        }
        catch (Throwable t) {
            throw new EncodingFailureException("Serializing of content + " + RedactableArgument.redactUser((Object)input) + " to JSON failed.", t);
        }
    }

    @Override
    public <T> T deserialize(Class<T> target, byte[] input) {
        if (target.equals(byte[].class)) {
            return (T)input;
        }
        try {
            return (T)this.mapper.readValue(input, target);
        }
        catch (Throwable e) {
            throw new DecodingFailureException("Deserialization of content into target " + target + " failed; encoded = " + RedactableArgument.redactUser((Object)new String(input, StandardCharsets.UTF_8)), e);
        }
    }

    @Override
    public <T> T deserialize(TypeRef<T> target, byte[] input) {
        try {
            JavaType type = this.mapper.getTypeFactory().constructType(target.type());
            return (T)this.mapper.readValue(input, type);
        }
        catch (Throwable e) {
            throw new DecodingFailureException("Deserialization of content into target " + target + " failed; encoded = " + RedactableArgument.redactUser((Object)new String(input, StandardCharsets.UTF_8)), e);
        }
    }
}

