/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.analytics;

import com.couchbase.client.core.Reactor;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.util.ReactorOps;
import com.couchbase.client.java.AsyncCluster;
import com.couchbase.client.java.manager.analytics.AnalyticsDataType;
import com.couchbase.client.java.manager.analytics.AnalyticsDataset;
import com.couchbase.client.java.manager.analytics.AnalyticsDataverse;
import com.couchbase.client.java.manager.analytics.AnalyticsIndex;
import com.couchbase.client.java.manager.analytics.AsyncAnalyticsIndexManager;
import com.couchbase.client.java.manager.analytics.ConnectLinkAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.CreateDatasetAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.CreateDataverseAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.CreateIndexAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.CreateLinkAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.DisconnectLinkAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.DropDatasetAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.DropDataverseAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.DropIndexAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.DropLinkAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.GetAllDatasetsAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.GetAllDataversesAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.GetAllIndexesAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.GetLinksAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.GetPendingMutationsAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.ReplaceLinkAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.link.AnalyticsLink;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveAnalyticsIndexManager {
    private final AsyncAnalyticsIndexManager async;
    private final ReactorOps reactor;

    @Stability.Internal
    public ReactiveAnalyticsIndexManager(AsyncCluster cluster) {
        this.reactor = cluster.environment();
        this.async = new AsyncAnalyticsIndexManager(cluster);
    }

    public AsyncAnalyticsIndexManager async() {
        return this.async;
    }

    public Mono<Void> createDataverse(String dataverseName) {
        return this.reactor.publishOnUserScheduler(() -> this.async.createDataverse(dataverseName));
    }

    public Mono<Void> createDataverse(String dataverseName, CreateDataverseAnalyticsOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.async.createDataverse(dataverseName, options));
    }

    public Mono<Void> dropDataverse(String dataverseName) {
        return this.reactor.publishOnUserScheduler(() -> this.async.dropDataverse(dataverseName));
    }

    public Mono<Void> dropDataverse(String dataverseName, DropDataverseAnalyticsOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.async.dropDataverse(dataverseName, options));
    }

    @Stability.Uncommitted
    public Flux<AnalyticsDataverse> getAllDataverses() {
        return this.reactor.publishOnUserScheduler(Reactor.toFlux(this.async::getAllDataverses));
    }

    @Stability.Uncommitted
    public Flux<AnalyticsDataverse> getAllDataverses(GetAllDataversesAnalyticsOptions options) {
        return this.reactor.publishOnUserScheduler(Reactor.toFlux(() -> this.async.getAllDataverses(options)));
    }

    public Mono<Void> createDataset(String datasetName, String bucketName) {
        return this.reactor.publishOnUserScheduler(() -> this.async.createDataset(datasetName, bucketName));
    }

    public Mono<Void> createDataset(String datasetName, String bucketName, CreateDatasetAnalyticsOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.async.createDataset(datasetName, bucketName, options));
    }

    public Mono<Void> dropDataset(String datasetName) {
        return this.reactor.publishOnUserScheduler(() -> this.async.dropDataset(datasetName));
    }

    public Mono<Void> dropDataset(String datasetName, DropDatasetAnalyticsOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.async.dropDataset(datasetName, options));
    }

    public Flux<AnalyticsDataset> getAllDatasets() {
        return this.reactor.publishOnUserScheduler(Reactor.toFlux(this.async::getAllDatasets));
    }

    public Flux<AnalyticsDataset> getAllDatasets(GetAllDatasetsAnalyticsOptions options) {
        return this.reactor.publishOnUserScheduler(Reactor.toFlux(() -> this.async.getAllDatasets(options)));
    }

    public Mono<Void> createIndex(String indexName, String datasetName, Map<String, AnalyticsDataType> fields) {
        return this.reactor.publishOnUserScheduler(() -> this.async.createIndex(indexName, datasetName, fields));
    }

    public Mono<Void> createIndex(String indexName, String datasetName, Map<String, AnalyticsDataType> fields, CreateIndexAnalyticsOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.async.createIndex(indexName, datasetName, fields, options));
    }

    public Mono<Void> dropIndex(String indexName, String datasetName) {
        return this.reactor.publishOnUserScheduler(() -> this.async.dropIndex(indexName, datasetName));
    }

    public Mono<Void> dropIndex(String indexName, String datasetName, DropIndexAnalyticsOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.async.dropIndex(indexName, datasetName, options));
    }

    public Flux<AnalyticsIndex> getAllIndexes() {
        return this.reactor.publishOnUserScheduler(Reactor.toFlux(this.async::getAllIndexes));
    }

    public Flux<AnalyticsIndex> getAllIndexes(GetAllIndexesAnalyticsOptions options) {
        return this.reactor.publishOnUserScheduler(Reactor.toFlux(() -> this.async.getAllIndexes(options)));
    }

    public Mono<Void> connectLink() {
        return this.reactor.publishOnUserScheduler(this.async::connectLink);
    }

    public Mono<Void> connectLink(ConnectLinkAnalyticsOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.async.connectLink(options));
    }

    public Mono<Void> disconnectLink() {
        return this.reactor.publishOnUserScheduler(this.async::disconnectLink);
    }

    public Mono<Void> disconnectLink(DisconnectLinkAnalyticsOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.async.disconnectLink(options));
    }

    public Mono<Map<String, Map<String, Long>>> getPendingMutations() {
        return this.reactor.publishOnUserScheduler(this.async::getPendingMutations);
    }

    public Mono<Map<String, Map<String, Long>>> getPendingMutations(GetPendingMutationsAnalyticsOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.async.getPendingMutations(options));
    }

    public Mono<Void> createLink(AnalyticsLink link) {
        return this.reactor.publishOnUserScheduler(() -> this.async.createLink(link));
    }

    public Mono<Void> createLink(AnalyticsLink link, CreateLinkAnalyticsOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.async.createLink(link, options));
    }

    public Mono<Void> replaceLink(AnalyticsLink link) {
        return this.reactor.publishOnUserScheduler(() -> this.async.replaceLink(link));
    }

    public Mono<Void> replaceLink(AnalyticsLink link, ReplaceLinkAnalyticsOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.async.replaceLink(link, options));
    }

    public Mono<Void> dropLink(String linkName, String dataverse) {
        return this.reactor.publishOnUserScheduler(() -> this.async.dropLink(linkName, dataverse));
    }

    public Mono<Void> dropLink(String linkName, String dataverse, DropLinkAnalyticsOptions options) {
        return this.reactor.publishOnUserScheduler(() -> this.async.dropLink(linkName, dataverse, options));
    }

    public Flux<AnalyticsLink> getLinks() {
        return this.reactor.publishOnUserScheduler(Reactor.toFlux(this.async::getLinks));
    }

    public Flux<AnalyticsLink> getLinks(GetLinksAnalyticsOptions options) {
        return this.reactor.publishOnUserScheduler(Reactor.toFlux(() -> this.async.getLinks(options)));
    }
}

