/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.query;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.DecodingFailureException;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.codec.TypeRef;
import com.couchbase.client.java.json.JsonObject;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

@Stability.Volatile
public final class QueryRow {
    private final byte[] content;
    private final JsonSerializer deserializer;

    @Stability.Internal
    public QueryRow(byte[] content, JsonSerializer deserializer) {
        this.content = Objects.requireNonNull(content);
        this.deserializer = Objects.requireNonNull(deserializer);
    }

    public byte[] bytes() {
        return this.content;
    }

    public JsonObject contentAsObject() {
        return this.contentAs(JsonObject.class);
    }

    public <T> T contentAs(Class<T> type) {
        Objects.requireNonNull(type, "`type` argument must be non-null");
        try {
            String corePackage = "com.couchbase.client.core";
            if (type.getName().startsWith(corePackage)) {
                throw new IllegalArgumentException("Classes in internal API package '" + corePackage + "' are not valid deserialization targets. Did you mean to import this class from a different package? " + type);
            }
            return this.deserializer.deserialize(type, this.content);
        }
        catch (Exception e) {
            throw new DecodingFailureException((Throwable)e);
        }
    }

    public <T> T contentAs(TypeRef<T> type) {
        Objects.requireNonNull(type, "`type` argument must be non-null");
        try {
            return this.deserializer.deserialize(type, this.content);
        }
        catch (Exception e) {
            throw new DecodingFailureException((Throwable)e);
        }
    }

    public String toString() {
        return new String(this.content, StandardCharsets.UTF_8);
    }
}

