/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.metrics.micrometer;

import com.couchbase.client.core.cnc.Counter;
import com.couchbase.client.core.cnc.Meter;
import com.couchbase.client.core.cnc.ValueRecorder;
import com.couchbase.client.core.cnc.metrics.MeterConventions;
import com.couchbase.client.core.cnc.metrics.NameAndTags;
import com.couchbase.client.core.error.MeterException;
import com.couchbase.client.metrics.micrometer.MicrometerCounter;
import com.couchbase.client.metrics.micrometer.MicrometerValueRecorder;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class MicrometerMeter
implements Meter {
    private final MeterRegistry meterRegistry;
    private final Map<NameAndTags, MicrometerCounter> counters = new ConcurrentHashMap<NameAndTags, MicrometerCounter>();
    private final Map<NameAndTags, MicrometerValueRecorder> valueRecorders = new ConcurrentHashMap<NameAndTags, MicrometerValueRecorder>();

    public static MicrometerMeter wrap(MeterRegistry meterRegistry) {
        return new MicrometerMeter(meterRegistry);
    }

    private MicrometerMeter(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    public Counter counter(String name, Map<String, String> tags) {
        try {
            Map<String, String> filteredTags = MicrometerMeter.filterTags(tags);
            return this.counters.computeIfAbsent(new NameAndTags(name, filteredTags), key -> new MicrometerCounter(this.meterRegistry.counter(name, MicrometerMeter.convertTags(filteredTags))));
        }
        catch (Exception ex) {
            throw new MeterException("Failed to create/access Counter", (Throwable)ex);
        }
    }

    public ValueRecorder valueRecorder(String name, Map<String, String> tags) {
        try {
            Map<String, String> filteredTags = MicrometerMeter.filterTags(tags);
            return this.valueRecorders.computeIfAbsent(new NameAndTags(name, filteredTags), key -> new MicrometerValueRecorder(this.meterRegistry.summary(name, MicrometerMeter.convertTags(filteredTags))));
        }
        catch (Exception ex) {
            throw new MeterException("Failed to create/access ValueRecorder", (Throwable)ex);
        }
    }

    private static Iterable<Tag> convertTags(Map<String, String> tags) {
        return tags.entrySet().stream().map(e -> Tag.of((String)((String)e.getKey()), (String)((String)e.getValue()))).collect(Collectors.toList());
    }

    private static Map<String, String> filterTags(Map<String, String> tags) {
        HashMap<String, String> out = new HashMap<String, String>();
        tags.forEach((k, v) -> {
            if (!MeterConventions.isTagReserved((String)k)) {
                out.put((String)k, v == null ? "" : v);
            }
        });
        return out;
    }
}

