/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.metrics.opentelemetry;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.Counter;
import com.couchbase.client.core.cnc.Meter;
import com.couchbase.client.core.cnc.ValueRecorder;
import com.couchbase.client.core.cnc.metrics.MeterConventions;
import com.couchbase.client.core.cnc.metrics.NameAndTags;
import com.couchbase.client.core.env.VersionAndGitHash;
import com.couchbase.client.core.error.MeterException;
import com.couchbase.client.metrics.opentelemetry.OpenTelemetryCounter;
import com.couchbase.client.metrics.opentelemetry.OpenTelemetryValueRecorder;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.DoubleHistogramBuilder;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.MeterProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Stability.Volatile
public class OpenTelemetryMeter
implements Meter {
    public static final String INSTRUMENTATION_NAME = "com.couchbase.client.jvm";
    private static final VersionAndGitHash version = VersionAndGitHash.from(OpenTelemetryMeter.class);
    private final io.opentelemetry.api.metrics.Meter otMeter;
    private final Map<NameAndTags, OpenTelemetryCounter> counters = new ConcurrentHashMap<NameAndTags, OpenTelemetryCounter>();
    private final Map<NameAndTags, OpenTelemetryValueRecorder> valueRecorders = new ConcurrentHashMap<NameAndTags, OpenTelemetryValueRecorder>();

    @Stability.Volatile
    public static OpenTelemetryMeter wrap(OpenTelemetry openTelemetry) {
        return new OpenTelemetryMeter(openTelemetry.getMeterProvider());
    }

    @Stability.Volatile
    public static OpenTelemetryMeter wrap(MeterProvider meterProvider) {
        return new OpenTelemetryMeter(meterProvider);
    }

    private OpenTelemetryMeter(MeterProvider meterProvider) {
        this.otMeter = version != null ? meterProvider.meterBuilder(INSTRUMENTATION_NAME).setInstrumentationVersion(version.version()).build() : meterProvider.get(INSTRUMENTATION_NAME);
    }

    public Counter counter(String name, Map<String, String> tagsOriginal) {
        try {
            Map<String, String> tags = OpenTelemetryMeter.filterTags(tagsOriginal);
            return this.counters.computeIfAbsent(new NameAndTags(name, tags), key -> {
                LongCounter counter = this.otMeter.counterBuilder(name).build();
                AttributesBuilder builder = Attributes.builder();
                for (Map.Entry tag : tags.entrySet()) {
                    builder.put((String)tag.getKey(), (String)tag.getValue());
                }
                return new OpenTelemetryCounter(counter, builder.build());
            });
        }
        catch (Exception ex) {
            throw new MeterException("Failed to create/access Counter", (Throwable)ex);
        }
    }

    public ValueRecorder valueRecorder(String name, Map<String, String> tagsOriginal) {
        try {
            Map<String, String> tags = OpenTelemetryMeter.filterTags(tagsOriginal);
            return this.valueRecorders.computeIfAbsent(new NameAndTags(name, tags), key -> {
                boolean secondsMode;
                DoubleHistogramBuilder histogramBuilder = this.otMeter.histogramBuilder(name);
                String units = (String)tagsOriginal.get("__unit");
                boolean bl = secondsMode = units != null && units.equals("s");
                if (secondsMode) {
                    histogramBuilder.setUnit(units);
                }
                DoubleHistogram vc = histogramBuilder.build();
                AttributesBuilder builder = Attributes.builder();
                for (Map.Entry tag : tags.entrySet()) {
                    builder.put((String)tag.getKey(), (String)tag.getValue());
                }
                return new OpenTelemetryValueRecorder(vc, builder.build(), secondsMode);
            });
        }
        catch (Exception ex) {
            throw new MeterException("Failed to create/access ValueRecorder", (Throwable)ex);
        }
    }

    private static Map<String, String> filterTags(Map<String, String> tags) {
        HashMap<String, String> out = new HashMap<String, String>();
        tags.forEach((k, v) -> {
            if (v != null && !MeterConventions.isTagReserved((String)k)) {
                out.put((String)k, (String)v);
            }
        });
        return out;
    }
}

