/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.metrics.opentelemetry;

import com.couchbase.client.core.cnc.ValueRecorder;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.DoubleHistogram;

public class OpenTelemetryValueRecorder
implements ValueRecorder {
    private final DoubleHistogram valueRecorder;
    private final Attributes attributes;
    private final boolean secondsMode;
    private static final double NANOS_TO_SECONDS = 1.0E9;

    public OpenTelemetryValueRecorder(DoubleHistogram valueRecorder, Attributes attributes) {
        this(valueRecorder, attributes, false);
    }

    public OpenTelemetryValueRecorder(DoubleHistogram valueRecorder, Attributes attributes, boolean secondsMode) {
        this.valueRecorder = valueRecorder;
        this.attributes = attributes;
        this.secondsMode = secondsMode;
    }

    public void recordValue(long value) {
        if (this.secondsMode) {
            double finalValue = (double)value / 1.0E9;
            this.valueRecorder.record(finalValue, this.attributes);
            return;
        }
        this.valueRecorder.record((double)value, this.attributes);
    }
}

