/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.analytics;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.CbTracing;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.cnc.tracing.RequestTracerAndDecorator;
import com.couchbase.client.core.cnc.tracing.TracingAttribute;
import com.couchbase.client.core.deps.com.fasterxml.jackson.core.type.TypeReference;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.endpoint.http.CoreHttpClient;
import com.couchbase.client.core.endpoint.http.CoreHttpPath;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.manager.CoreAnalyticsLinkManager;
import com.couchbase.client.core.msg.RequestTarget;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.AsyncCluster;
import com.couchbase.client.java.CommonOptions;
import com.couchbase.client.java.analytics.AnalyticsOptions;
import com.couchbase.client.java.analytics.AnalyticsResult;
import com.couchbase.client.java.manager.analytics.AnalyticsDataType;
import com.couchbase.client.java.manager.analytics.AnalyticsDataset;
import com.couchbase.client.java.manager.analytics.AnalyticsDataverse;
import com.couchbase.client.java.manager.analytics.AnalyticsIndex;
import com.couchbase.client.java.manager.analytics.ConnectLinkAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.CreateDatasetAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.CreateDataverseAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.CreateIndexAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.CreateLinkAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.DisconnectLinkAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.DropDatasetAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.DropDataverseAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.DropIndexAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.DropLinkAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.GetAllDatasetsAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.GetAllDataversesAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.GetAllIndexesAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.GetLinksAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.GetPendingMutationsAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.ReplaceLinkAnalyticsOptions;
import com.couchbase.client.java.manager.analytics.link.AnalyticsLink;
import com.couchbase.client.java.manager.analytics.link.AnalyticsLinkType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class AsyncAnalyticsIndexManager {
    private final AsyncCluster cluster;
    private final Core core;
    private final CoreHttpClient httpClient;
    private final CoreAnalyticsLinkManager linkManager;
    private static final String DEFAULT_DATAVERSE = "Default";
    private static final String DEFAULT_LINK = "Local";

    @Stability.Internal
    public AsyncAnalyticsIndexManager(AsyncCluster cluster) {
        this.cluster = Objects.requireNonNull(cluster);
        this.core = cluster.core();
        this.httpClient = this.core.httpClient(RequestTarget.analytics());
        this.linkManager = new CoreAnalyticsLinkManager(this.core);
    }

    public CompletableFuture<Void> createDataverse(String dataverseName) {
        return this.createDataverse(dataverseName, CreateDataverseAnalyticsOptions.createDataverseAnalyticsOptions());
    }

    public CompletableFuture<Void> createDataverse(String dataverseName, CreateDataverseAnalyticsOptions options) {
        Validators.notNullOrEmpty((String)dataverseName, (String)"DataverseName");
        Validators.notNull((Object)options, (String)"Options");
        CreateDataverseAnalyticsOptions.Built builtOpts = options.build();
        String statement = "CREATE DATAVERSE " + AsyncAnalyticsIndexManager.quoteDataverse(dataverseName, new String[0]);
        if (builtOpts.ignoreIfExists()) {
            statement = statement + " IF NOT EXISTS";
        }
        return this.exec(statement, builtOpts, "manager_analytics_create_dataverse").thenApply(result -> null);
    }

    @Stability.Uncommitted
    public CompletableFuture<List<AnalyticsDataverse>> getAllDataverses() {
        return this.getAllDataverses(GetAllDataversesAnalyticsOptions.getAllDataversesAnalyticsOptions());
    }

    @Stability.Uncommitted
    public CompletableFuture<List<AnalyticsDataverse>> getAllDataverses(GetAllDataversesAnalyticsOptions options) {
        Validators.notNull((Object)options, (String)"Options");
        GetAllDataversesAnalyticsOptions.Built builtOpts = options.build();
        String statement = "SELECT DataverseName from Metadata.`Dataverse`";
        return this.exec(statement, builtOpts, "manager_analytics_get_all_dataverses").thenApply(result -> result.rowsAsObject().stream().map(dv -> dv.put("DataverseName", ((String)dv.get("DataverseName")).replace("@.", "."))).map(AnalyticsDataverse::new).collect(Collectors.toList()));
    }

    public CompletableFuture<Void> dropDataverse(String dataverseName) {
        return this.dropDataverse(dataverseName, DropDataverseAnalyticsOptions.dropDataverseAnalyticsOptions());
    }

    public CompletableFuture<Void> dropDataverse(String dataverseName, DropDataverseAnalyticsOptions options) {
        Validators.notNullOrEmpty((String)dataverseName, (String)"DataverseName");
        Validators.notNull((Object)options, (String)"Options");
        DropDataverseAnalyticsOptions.Built builtOpts = options.build();
        String statement = "DROP DATAVERSE " + AsyncAnalyticsIndexManager.quoteDataverse(dataverseName, new String[0]);
        if (builtOpts.ignoreIfNotExists()) {
            statement = statement + " IF EXISTS";
        }
        return this.exec(statement, builtOpts, "manager_analytics_drop_dataverse").thenApply(result -> null);
    }

    public CompletableFuture<Void> createDataset(String datasetName, String bucketName) {
        return this.createDataset(datasetName, bucketName, CreateDatasetAnalyticsOptions.createDatasetAnalyticsOptions());
    }

    public CompletableFuture<Void> createDataset(String datasetName, String bucketName, CreateDatasetAnalyticsOptions options) {
        Validators.notNullOrEmpty((String)datasetName, (String)"DatasetName");
        Validators.notNullOrEmpty((String)bucketName, (String)"BucketName");
        Validators.notNull((Object)options, (String)"Options");
        CreateDatasetAnalyticsOptions.Built builtOpts = options.build();
        String dataverseName = builtOpts.dataverseName().orElse(DEFAULT_DATAVERSE);
        String condition = builtOpts.condition().orElse(null);
        String statement = "CREATE DATASET ";
        if (builtOpts.ignoreIfExists()) {
            statement = statement + "IF NOT EXISTS ";
        }
        statement = statement + AsyncAnalyticsIndexManager.quoteDataverse(dataverseName, datasetName) + " ON " + AsyncAnalyticsIndexManager.quote(bucketName);
        if (condition != null) {
            statement = statement + " WHERE " + condition;
        }
        return this.exec(statement, builtOpts, "manager_analytics_create_dataset").thenApply(result -> null);
    }

    public CompletableFuture<Void> dropDataset(String datasetName) {
        return this.dropDataset(datasetName, DropDatasetAnalyticsOptions.dropDatasetAnalyticsOptions());
    }

    public CompletableFuture<Void> dropDataset(String datasetName, DropDatasetAnalyticsOptions options) {
        Validators.notNullOrEmpty((String)datasetName, (String)"DatasetName");
        Validators.notNull((Object)options, (String)"Options");
        DropDatasetAnalyticsOptions.Built builtOpts = options.build();
        String dataverseName = builtOpts.dataverseName().orElse(DEFAULT_DATAVERSE);
        String statement = "DROP DATASET " + AsyncAnalyticsIndexManager.quoteDataverse(dataverseName, datasetName);
        if (builtOpts.ignoreIfNotExists()) {
            statement = statement + " IF EXISTS";
        }
        return this.exec(statement, builtOpts, "manager_analytics_drop_dataset").thenApply(result -> null);
    }

    public CompletableFuture<List<AnalyticsDataset>> getAllDatasets() {
        return this.getAllDatasets(GetAllDatasetsAnalyticsOptions.getAllDatasetsAnalyticsOptions());
    }

    public CompletableFuture<List<AnalyticsDataset>> getAllDatasets(GetAllDatasetsAnalyticsOptions options) {
        Validators.notNull((Object)options, (String)"Options");
        GetAllDatasetsAnalyticsOptions.Built builtOpts = options.build();
        String statement = "SELECT d.* FROM Metadata.`Dataset` d WHERE d.DataverseName <> \"Metadata\"";
        return this.exec(statement, builtOpts, "manager_analytics_get_all_datasets").thenApply(result -> result.rowsAsObject().stream().map(AnalyticsDataset::new).collect(Collectors.toList()));
    }

    public CompletableFuture<Void> createIndex(String indexName, String datasetName, Map<String, AnalyticsDataType> fields) {
        return this.createIndex(indexName, datasetName, fields, CreateIndexAnalyticsOptions.createIndexAnalyticsOptions());
    }

    public CompletableFuture<Void> createIndex(String indexName, String datasetName, Map<String, AnalyticsDataType> fields, CreateIndexAnalyticsOptions options) {
        Validators.notNullOrEmpty((String)indexName, (String)"IndexName");
        Validators.notNullOrEmpty((String)datasetName, (String)"DatasetName");
        Validators.notNull(fields, (String)"Fields");
        Validators.notNull((Object)options, (String)"Options");
        CreateIndexAnalyticsOptions.Built builtOpts = options.build();
        String dataverseName = builtOpts.dataverseName().orElse(DEFAULT_DATAVERSE);
        String statement = "CREATE INDEX " + AsyncAnalyticsIndexManager.quote(indexName);
        if (builtOpts.ignoreIfExists()) {
            statement = statement + " IF NOT EXISTS";
        }
        statement = statement + " ON " + AsyncAnalyticsIndexManager.quoteDataverse(dataverseName, datasetName) + " " + AsyncAnalyticsIndexManager.formatIndexFields(fields);
        return this.exec(statement, builtOpts, "manager_analytics_create_index").thenApply(result -> null);
    }

    public CompletableFuture<List<AnalyticsIndex>> getAllIndexes() {
        return this.getAllIndexes(GetAllIndexesAnalyticsOptions.getAllIndexesAnalyticsOptions());
    }

    public CompletableFuture<List<AnalyticsIndex>> getAllIndexes(GetAllIndexesAnalyticsOptions options) {
        Validators.notNull((Object)options, (String)"Options");
        GetAllIndexesAnalyticsOptions.Built builtOpts = options.build();
        String statement = "SELECT d.* FROM Metadata.`Index` d WHERE d.DataverseName <> \"Metadata\"";
        return this.exec(statement, builtOpts, "manager_analytics_get_all_indexes").thenApply(result -> result.rowsAsObject().stream().map(AnalyticsIndex::new).collect(Collectors.toList()));
    }

    public CompletableFuture<Void> dropIndex(String indexName, String datasetName) {
        return this.dropIndex(indexName, datasetName, DropIndexAnalyticsOptions.dropIndexAnalyticsOptions());
    }

    public CompletableFuture<Void> dropIndex(String indexName, String datasetName, DropIndexAnalyticsOptions options) {
        Validators.notNullOrEmpty((String)indexName, (String)"IndexName");
        Validators.notNullOrEmpty((String)datasetName, (String)"DatasetName");
        Validators.notNull((Object)options, (String)"Options");
        DropIndexAnalyticsOptions.Built builtOpts = options.build();
        String dataverseName = builtOpts.dataverseName().orElse(DEFAULT_DATAVERSE);
        String statement = "DROP INDEX " + AsyncAnalyticsIndexManager.quoteDataverse(dataverseName, datasetName, indexName);
        if (builtOpts.ignoreIfNotExists()) {
            statement = statement + " IF EXISTS";
        }
        return this.exec(statement, builtOpts, "manager_analytics_drop_index").thenApply(result -> null);
    }

    public CompletableFuture<Map<String, Map<String, Long>>> getPendingMutations() {
        return this.getPendingMutations(GetPendingMutationsAnalyticsOptions.getPendingMutationsAnalyticsOptions());
    }

    public CompletableFuture<Map<String, Map<String, Long>>> getPendingMutations(GetPendingMutationsAnalyticsOptions options) {
        Validators.notNull((Object)options, (String)"Options");
        return this.httpClient.get(CoreHttpPath.path((String)"/analytics/node/agg/stats/remaining"), (CoreCommonOptions)options.build()).trace("manager_analytics_get_pending_mutations").exec(this.core).thenApply(response -> (Map)Mapper.decodeInto((byte[])response.content(), (TypeReference)new TypeReference<Map<String, Map<String, Long>>>(){}));
    }

    public CompletableFuture<Void> connectLink() {
        return this.connectLink(ConnectLinkAnalyticsOptions.connectLinkAnalyticsOptions());
    }

    public CompletableFuture<Void> connectLink(ConnectLinkAnalyticsOptions options) {
        Validators.notNull((Object)options, (String)"Options");
        ConnectLinkAnalyticsOptions.Built builtOpts = options.build();
        String statement = "CONNECT LINK " + AsyncAnalyticsIndexManager.quoteDataverse(builtOpts.dataverseName().orElse(DEFAULT_DATAVERSE), builtOpts.linkName().orElse(DEFAULT_LINK));
        if (builtOpts.force()) {
            statement = statement + " WITH " + Mapper.encodeAsString(Collections.singletonMap("force", true));
        }
        return this.exec(statement, builtOpts, "manager_analytics_connect_link").thenApply(result -> null);
    }

    public CompletableFuture<Void> disconnectLink() {
        return this.disconnectLink(DisconnectLinkAnalyticsOptions.disconnectLinkAnalyticsOptions());
    }

    public CompletableFuture<Void> disconnectLink(DisconnectLinkAnalyticsOptions options) {
        Validators.notNull((Object)options, (String)"Options");
        DisconnectLinkAnalyticsOptions.Built builtOpts = options.build();
        String statement = "DISCONNECT LINK " + AsyncAnalyticsIndexManager.quoteDataverse(builtOpts.dataverseName().orElse(DEFAULT_DATAVERSE), builtOpts.linkName().orElse(DEFAULT_LINK));
        return this.exec(statement, builtOpts, "manager_analytics_disconnect_link").thenApply(result -> null);
    }

    public CompletableFuture<Void> createLink(AnalyticsLink link) {
        return this.createLink(link, CreateLinkAnalyticsOptions.createLinkAnalyticsOptions());
    }

    public CompletableFuture<Void> createLink(AnalyticsLink link, CreateLinkAnalyticsOptions options) {
        return this.linkManager.createLink(link.toMap(), (CoreCommonOptions)options.build());
    }

    public CompletableFuture<Void> replaceLink(AnalyticsLink link) {
        return this.replaceLink(link, ReplaceLinkAnalyticsOptions.replaceLinkAnalyticsOptions());
    }

    public CompletableFuture<Void> replaceLink(AnalyticsLink link, ReplaceLinkAnalyticsOptions options) {
        return this.linkManager.replaceLink(link.toMap(), (CoreCommonOptions)options.build());
    }

    public CompletableFuture<Void> dropLink(String linkName, String dataverse) {
        return this.dropLink(linkName, dataverse, DropLinkAnalyticsOptions.dropLinkAnalyticsOptions());
    }

    public CompletableFuture<Void> dropLink(String linkName, String dataverse, DropLinkAnalyticsOptions options) {
        Validators.notNullOrEmpty((String)linkName, (String)"LinkName");
        Validators.notNullOrEmpty((String)dataverse, (String)"Dataverse");
        Validators.notNull((Object)options, (String)"Options");
        return this.linkManager.dropLink(linkName, dataverse, (CoreCommonOptions)options.build());
    }

    public CompletableFuture<List<AnalyticsLink>> getLinks() {
        return this.getLinks(GetLinksAnalyticsOptions.getLinksAnalyticsOptions());
    }

    public CompletableFuture<List<AnalyticsLink>> getLinks(GetLinksAnalyticsOptions options) {
        Validators.notNull((Object)options, (String)"Options");
        GetLinksAnalyticsOptions.Built opts = options.build();
        String dataverseName = opts.dataverseName().orElse(null);
        String linkType = opts.linkType().map(AnalyticsLinkType::wireName).orElse(null);
        String linkName = opts.name().orElse(null);
        return this.linkManager.getLinks(dataverseName, linkType, linkName, (CoreCommonOptions)opts).thenApply(responseBytes -> (List)Mapper.decodeInto((byte[])responseBytes, (TypeReference)new TypeReference<List<AnalyticsLink>>(){}));
    }

    static String formatIndexFields(Map<String, AnalyticsDataType> fields) {
        ArrayList result = new ArrayList();
        fields.forEach((k, v) -> result.add(AsyncAnalyticsIndexManager.quote(k) + ":" + v.value()));
        return "(" + String.join((CharSequence)",", result) + ")";
    }

    private CompletableFuture<AnalyticsResult> exec(String statement, CommonOptions.BuiltCommonOptions options, String spanName) {
        RequestTracerAndDecorator tracerAndTip = this.core.coreResources().requestTracerAndDecorator();
        RequestSpan parent = tracerAndTip.requestTracer.requestSpan(spanName, (RequestSpan)options.parentSpan().orElse(null));
        if (!CbTracing.isInternalSpan((RequestSpan)parent)) {
            tracerAndTip.decorator.provideAttr(TracingAttribute.STATEMENT, parent, statement);
        }
        AnalyticsOptions analyticsOptions = (AnalyticsOptions)AsyncAnalyticsIndexManager.toAnalyticsOptions(options).parentSpan(parent);
        return this.cluster.analyticsQuery(statement, analyticsOptions).whenComplete((r, t) -> parent.end());
    }

    private static AnalyticsOptions toAnalyticsOptions(CommonOptions.BuiltCommonOptions options) {
        AnalyticsOptions result = AnalyticsOptions.analyticsOptions();
        options.timeout().ifPresent(result::timeout);
        options.retryStrategy().ifPresent(result::retryStrategy);
        result.clientContext(options.clientContext());
        return result;
    }

    private static String quote(String s) {
        if (s.contains("`")) {
            throw InvalidArgumentException.fromMessage((String)("Value [" + RedactableArgument.redactMeta((Object)s) + "] may not contain backticks."));
        }
        return "`" + s + "`";
    }

    static String quoteDataverse(String dataverseName, String ... otherComponents) {
        ArrayList<String> components = new ArrayList<String>();
        components.addAll(Arrays.asList(dataverseName.split("/", -1)));
        components.addAll(Arrays.asList(otherComponents));
        return components.stream().map(AsyncAnalyticsIndexManager::quote).collect(Collectors.joining("."));
    }
}

