/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.eventing;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.java.AsyncUtils;
import com.couchbase.client.java.manager.eventing.AsyncEventingFunctionManager;
import com.couchbase.client.java.manager.eventing.DeployFunctionOptions;
import com.couchbase.client.java.manager.eventing.DropFunctionOptions;
import com.couchbase.client.java.manager.eventing.EventingFunction;
import com.couchbase.client.java.manager.eventing.EventingStatus;
import com.couchbase.client.java.manager.eventing.FunctionsStatusOptions;
import com.couchbase.client.java.manager.eventing.GetAllFunctionsOptions;
import com.couchbase.client.java.manager.eventing.GetFunctionOptions;
import com.couchbase.client.java.manager.eventing.PauseFunctionOptions;
import com.couchbase.client.java.manager.eventing.ResumeFunctionOptions;
import com.couchbase.client.java.manager.eventing.UndeployFunctionOptions;
import com.couchbase.client.java.manager.eventing.UpsertFunctionOptions;
import java.util.List;

@Stability.Uncommitted
public class EventingFunctionManager {
    private final AsyncEventingFunctionManager asyncManager;

    @Stability.Internal
    public EventingFunctionManager(AsyncEventingFunctionManager asyncManager) {
        this.asyncManager = asyncManager;
    }

    public void upsertFunction(EventingFunction function) {
        this.upsertFunction(function, UpsertFunctionOptions.upsertFunctionOptions());
    }

    public void upsertFunction(EventingFunction function, UpsertFunctionOptions options) {
        AsyncUtils.block(this.asyncManager.upsertFunction(function, options));
    }

    public EventingFunction getFunction(String name) {
        return this.getFunction(name, GetFunctionOptions.getFunctionOptions());
    }

    public EventingFunction getFunction(String name, GetFunctionOptions options) {
        return AsyncUtils.block(this.asyncManager.getFunction(name, options));
    }

    public List<EventingFunction> getAllFunctions() {
        return this.getAllFunctions(GetAllFunctionsOptions.getAllFunctionsOptions());
    }

    public List<EventingFunction> getAllFunctions(GetAllFunctionsOptions options) {
        return AsyncUtils.block(this.asyncManager.getAllFunctions(options));
    }

    public void dropFunction(String name) {
        this.dropFunction(name, DropFunctionOptions.dropFunctionOptions());
    }

    public void dropFunction(String name, DropFunctionOptions options) {
        AsyncUtils.block(this.asyncManager.dropFunction(name, options));
    }

    public void deployFunction(String name) {
        this.deployFunction(name, DeployFunctionOptions.deployFunctionOptions());
    }

    public void deployFunction(String name, DeployFunctionOptions options) {
        AsyncUtils.block(this.asyncManager.deployFunction(name, options));
    }

    public void undeployFunction(String name) {
        this.undeployFunction(name, UndeployFunctionOptions.undeployFunctionOptions());
    }

    public void undeployFunction(String name, UndeployFunctionOptions options) {
        AsyncUtils.block(this.asyncManager.undeployFunction(name, options));
    }

    public void pauseFunction(String name) {
        this.pauseFunction(name, PauseFunctionOptions.pauseFunctionOptions());
    }

    public void pauseFunction(String name, PauseFunctionOptions options) {
        AsyncUtils.block(this.asyncManager.pauseFunction(name, options));
    }

    public void resumeFunction(String name) {
        this.resumeFunction(name, ResumeFunctionOptions.resumeFunctionOptions());
    }

    public void resumeFunction(String name, ResumeFunctionOptions options) {
        AsyncUtils.block(this.asyncManager.resumeFunction(name, options));
    }

    public EventingStatus functionsStatus() {
        return this.functionsStatus(FunctionsStatusOptions.functionsStatusOptions());
    }

    public EventingStatus functionsStatus(FunctionsStatusOptions options) {
        return AsyncUtils.block(this.asyncManager.functionsStatus(options));
    }
}

