/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.search.queries;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.search.CoreSearchQuery;
import com.couchbase.client.core.api.search.queries.CoreGeoCoordinates;
import com.couchbase.client.core.api.search.queries.CoreGeoPoint;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.protostellar.CoreProtostellarUtil;
import com.couchbase.client.protostellar.search.v1.GeoBoundingBoxQuery;
import com.couchbase.client.protostellar.search.v1.Query;
import java.util.Objects;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class CoreGeoBoundingBoxQuery
extends CoreSearchQuery {
    private final CoreGeoPoint topLeft;
    private final CoreGeoPoint bottomRight;
    @Nullable
    private final String field;

    public CoreGeoBoundingBoxQuery(double topLeftLon, double topLeftLat, double bottomRightLon, double bottomRightLat, @Nullable String field, @Nullable Double boost) {
        this(CoreGeoCoordinates.lon(topLeftLon).lat(topLeftLat), CoreGeoCoordinates.lon(bottomRightLon).lat(bottomRightLat), field, boost);
    }

    public CoreGeoBoundingBoxQuery(CoreGeoPoint topLeft, CoreGeoPoint bottomRight, @Nullable String field, @Nullable Double boost) {
        super(boost);
        this.topLeft = Objects.requireNonNull(topLeft);
        this.bottomRight = Objects.requireNonNull(bottomRight);
        this.field = field;
    }

    @Override
    protected void injectParams(ObjectNode input) {
        input.set("top_left", this.topLeft.toJson());
        input.set("bottom_right", this.bottomRight.toJson());
        if (this.field != null) {
            input.put("field", this.field);
        }
    }

    @Override
    public Query asProtostellar() {
        GeoBoundingBoxQuery.Builder builder = GeoBoundingBoxQuery.newBuilder().setTopLeft(CoreProtostellarUtil.toLatLng(this.topLeft)).setBottomRight(CoreProtostellarUtil.toLatLng(this.bottomRight));
        if (this.field != null) {
            builder.setField(this.field);
        }
        if (this.boost != null) {
            builder.setBoost(this.boost.floatValue());
        }
        return Query.newBuilder().setGeoBoundingBoxQuery(builder).build();
    }
}

