/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.search.vector;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.search.vector.CoreVectorQuery;
import com.couchbase.client.core.api.search.vector.CoreVectorSearchOptions;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ArrayNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.util.Validators;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class CoreVectorSearch {
    public final List<CoreVectorQuery> vectorQueries;
    @Nullable
    public final CoreVectorSearchOptions options;

    public CoreVectorSearch(List<CoreVectorQuery> vectorQueries, @Nullable CoreVectorSearchOptions options) {
        if (vectorQueries.isEmpty()) {
            throw new InvalidArgumentException("At least one VectorQuery must be specified", null, null);
        }
        vectorQueries.forEach(vq -> Validators.notNull(vq, "VectorQuery"));
        this.vectorQueries = Objects.requireNonNull(vectorQueries);
        this.options = options;
    }

    public void injectTopLevel(ObjectNode toSend) {
        ArrayNode knn = Mapper.createArrayNode();
        for (CoreVectorQuery vectorQuery : this.vectorQueries) {
            knn.add(vectorQuery.toJson());
        }
        toSend.set("knn", knn);
        if (this.options != null) {
            this.options.injectTopLevel(toSend);
        }
    }
}

