/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.classic.query;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.query.CoreQueryMetaData;
import com.couchbase.client.core.api.query.CoreReactiveQueryResult;
import com.couchbase.client.core.classic.query.ClassicCoreQueryMetaData;
import com.couchbase.client.core.msg.query.QueryChunkRow;
import com.couchbase.client.core.msg.query.QueryResponse;
import com.couchbase.client.core.topology.NodeIdentifier;
import com.couchbase.client.core.util.Validators;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class ClassicCoreReactiveQueryResult
extends CoreReactiveQueryResult {
    private final QueryResponse response;
    @Nullable
    private final NodeIdentifier lastDispatchedTo;

    @Stability.Internal
    public ClassicCoreReactiveQueryResult(QueryResponse response, @Nullable NodeIdentifier lastDispatchedTo) {
        this.response = Validators.notNull(response, "response");
        this.lastDispatchedTo = lastDispatchedTo;
    }

    @Override
    public Flux<QueryChunkRow> rows() {
        return this.response.rows();
    }

    @Override
    public Mono<CoreQueryMetaData> metaData() {
        return this.response.trailer().map(t -> ClassicCoreQueryMetaData.from(this.response.header(), t));
    }

    @Override
    public NodeIdentifier lastDispatchedTo() {
        return this.lastDispatchedTo;
    }

    public QueryResponse internal() {
        return this.response;
    }
}

