/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.cnc;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.annotation.UsedBy;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.cnc.RequestTracer;
import com.couchbase.client.core.cnc.tracing.NoopRequestSpan;
import com.couchbase.client.core.cnc.tracing.NoopRequestTracer;
import com.couchbase.client.core.cnc.tracing.ThresholdLoggingTracer;
import com.couchbase.client.core.cnc.tracing.ThresholdRequestSpan;
import com.couchbase.client.core.cnc.tracing.TracingAttribute;
import com.couchbase.client.core.cnc.tracing.TracingDecorator;
import java.util.Map;

@Stability.Internal
public class CbTracing {
    private CbTracing() {
        throw new AssertionError((Object)"not instantiable");
    }

    public static boolean isInternalTracer(RequestTracer tracer) {
        return tracer instanceof NoopRequestTracer || tracer instanceof ThresholdLoggingTracer;
    }

    public static boolean isInternalSpan(RequestSpan span) {
        return span instanceof NoopRequestSpan || span instanceof ThresholdRequestSpan;
    }

    @UsedBy(value=UsedBy.Project.SPRING_DATA_COUCHBASE)
    public static RequestSpan newSpan(CoreContext coreContext, String spanName, RequestSpan parent) {
        return coreContext.coreResources().requestTracer().requestSpan(spanName, parent);
    }

    @Deprecated
    public static RequestSpan newSpan(RequestTracer tracer, String spanName, RequestSpan parent) {
        return tracer.requestSpan(spanName, parent);
    }

    public static void setAttributes(TracingDecorator tip, RequestSpan span, Map<TracingAttribute, ?> attributes) {
        if (span == null || attributes == null) {
            return;
        }
        attributes.forEach((k, v) -> {
            if (v instanceof String) {
                tip.provideAttr((TracingAttribute)((Object)k), span, (String)v);
            } else if (v instanceof Integer || v instanceof Long) {
                tip.provideAttr((TracingAttribute)((Object)k), span, ((Number)v).longValue());
            } else if (v instanceof Boolean) {
                tip.provideAttr((TracingAttribute)((Object)k), span, (Boolean)v);
            } else {
                tip.provideAttr((TracingAttribute)((Object)k), span, String.valueOf(v));
            }
        });
    }
}

