/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.cnc.events.config;

import com.couchbase.client.core.cnc.AbstractEvent;
import com.couchbase.client.core.cnc.Event;
import java.time.Duration;

public class InsecureSecurityConfigDetectedEvent
extends AbstractEvent {
    private final boolean validateHosts;
    private final boolean insecureTrustManager;

    public InsecureSecurityConfigDetectedEvent(boolean validateHosts, boolean insecureTrustManager) {
        super(Event.Severity.WARN, Event.Category.CONFIG, Duration.ZERO, null);
        this.validateHosts = validateHosts;
        this.insecureTrustManager = insecureTrustManager;
    }

    @Override
    public String description() {
        StringBuilder sb = new StringBuilder();
        sb.append("Detected a potentially insecure SecurityConfig - Reason: ");
        if (!this.validateHosts) {
            sb.append("hostname validation is disabled");
            if (this.insecureTrustManager) {
                sb.append(" and ");
            }
        }
        if (this.insecureTrustManager) {
            sb.append("the InsecureTrustManager is used");
        }
        return sb.toString();
    }
}

