/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.cnc.metrics;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.Counter;
import com.couchbase.client.core.cnc.Meter;
import com.couchbase.client.core.cnc.ValueRecorder;
import com.couchbase.client.core.cnc.metrics.CounterName;
import com.couchbase.client.core.cnc.metrics.MeterProviderImpl;
import com.couchbase.client.core.cnc.metrics.ResponseMetricIdentifier;
import com.couchbase.client.core.cnc.metrics.ValueRecorderName;
import com.couchbase.client.core.cnc.tracing.TracingAttribute;
import com.couchbase.client.core.cnc.tracing.TracingDecoratorImpl;
import com.couchbase.client.core.cnc.tracing.TracingDecoratorImplV0;
import com.couchbase.client.core.topology.ClusterIdentifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@Stability.Internal
public class MeterProviderImplV0
implements MeterProviderImpl {
    private static final TracingDecoratorImpl tip = new TracingDecoratorImplV0();
    private final Meter originalMeter;

    public MeterProviderImplV0(Meter originalMeter) {
        this.originalMeter = Objects.requireNonNull(originalMeter);
    }

    private Map<String, String> tags(ResponseMetricIdentifier rmi) {
        HashMap<String, String> tags = new HashMap<String, String>(9);
        tags.put(tip.requireAttributeName(TracingAttribute.SYSTEM), "couchbase");
        tags.put(tip.requireAttributeName(TracingAttribute.SERVICE), rmi.service());
        tags.put(tip.requireAttributeName(TracingAttribute.OPERATION), rmi.operation());
        if (!rmi.isDefaultLoggingMeter()) {
            tags.put(tip.requireAttributeName(TracingAttribute.BUCKET_NAME), rmi.bucketName());
            tags.put(tip.requireAttributeName(TracingAttribute.SCOPE_NAME), rmi.scopeName());
            tags.put(tip.requireAttributeName(TracingAttribute.COLLECTION_NAME), rmi.collectionName());
            ClusterIdentifier clusterIdent = rmi.clusterIdent();
            tags.put(tip.requireAttributeName(TracingAttribute.CLUSTER_UUID), clusterIdent == null ? null : clusterIdent.clusterUuid());
            tags.put(tip.requireAttributeName(TracingAttribute.CLUSTER_NAME), clusterIdent == null ? null : clusterIdent.clusterName());
            if (rmi.exceptionSimpleName() != null) {
                tags.put(tip.requireAttributeName(TracingAttribute.OUTCOME), rmi.exceptionSimpleName());
            } else {
                tags.put(tip.requireAttributeName(TracingAttribute.OUTCOME), "Success");
            }
        }
        return tags;
    }

    private String mapName(CounterName metric) {
        switch (metric) {
            case TRANSACTIONS_COUNTER: {
                return "db.couchbase.transactions.total";
            }
            case TRANSACTIONS_ATTEMPT_COUNTER: {
                return "db.couchbase.transactions.attempts";
            }
        }
        throw new IllegalArgumentException("Unknown metric " + (Object)((Object)metric));
    }

    private String mapName(ValueRecorderName metric) {
        switch (metric) {
            case OPERATIONS: {
                return tip.meterOperations();
            }
        }
        throw new IllegalArgumentException("Unknown metric " + (Object)((Object)metric));
    }

    @Override
    public Counter counter(CounterName metric, ResponseMetricIdentifier rmi) {
        return this.originalMeter.counter(this.mapName(metric), this.tags(rmi));
    }

    @Override
    public ValueRecorder valueRecorder(ValueRecorderName metric, ResponseMetricIdentifier rmi) {
        return this.originalMeter.valueRecorder(this.mapName(metric), this.tags(rmi));
    }
}

