/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.config.ClusterCapabilities;
import com.couchbase.client.core.config.GlobalConfig;
import com.couchbase.client.core.config.LegacyConfigHelper;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.core.topology.ClusterTopology;
import com.couchbase.client.core.topology.ClusterTopologyWithBucket;
import com.couchbase.client.core.topology.TopologyRevision;
import com.couchbase.client.core.util.CbCollections;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import reactor.util.annotation.Nullable;

public class ClusterConfig {
    private final Map<String, BucketConfig> bucketConfigs = new ConcurrentHashMap<String, BucketConfig>();
    private final AtomicReference<GlobalConfig> globalConfig = new AtomicReference();

    @Stability.Internal
    public Set<String> bucketNames() {
        return this.bucketConfigs.keySet();
    }

    @Stability.Internal
    @Nullable
    public ClusterTopologyWithBucket bucketTopology(String bucketName) {
        BucketConfig bucketConfig = this.bucketConfigs.get(bucketName);
        return bucketConfig == null ? null : bucketConfig.asClusterTopology();
    }

    @Stability.Internal
    public Collection<ClusterTopologyWithBucket> bucketTopologies() {
        return CbCollections.transform(this.bucketConfigs.values(), BucketConfig::asClusterTopology);
    }

    @Stability.Internal
    @Nullable
    public ClusterTopology globalTopology() {
        GlobalConfig g = this.globalConfig();
        return g == null ? null : g.asClusterTopology();
    }

    public TopologyRevision globalTopologyRevision() {
        ClusterTopology t = this.globalTopology();
        return t == null ? TopologyRevision.ZERO : t.revision();
    }

    public TopologyRevision bucketTopologyRevision(String bucketName) {
        ClusterTopologyWithBucket t = this.bucketTopology(bucketName);
        return t == null ? TopologyRevision.ZERO : t.revision();
    }

    public BucketConfig bucketConfig(String bucketName) {
        return this.bucketConfigs.get(bucketName);
    }

    @Stability.Internal
    public void setBucketConfig(ClusterTopologyWithBucket topology) {
        this.bucketConfigs.put(topology.bucket().name(), LegacyConfigHelper.toLegacyBucketConfig(topology));
    }

    @Stability.Internal
    public void deleteBucketConfig(String bucketName) {
        this.bucketConfigs.remove(bucketName);
    }

    public Map<String, BucketConfig> bucketConfigs() {
        return this.bucketConfigs;
    }

    public GlobalConfig globalConfig() {
        return this.globalConfig.get();
    }

    @Stability.Internal
    public void setGlobalConfig(ClusterTopology config) {
        this.globalConfig.set(new GlobalConfig(config));
    }

    @Stability.Internal
    public void deleteGlobalConfig() {
        this.globalConfig.set(null);
    }

    public boolean hasClusterOrBucketConfig() {
        return !this.bucketConfigs.isEmpty() || this.globalConfig() != null;
    }

    @Deprecated
    public Set<String> allNodeAddresses() {
        HashSet<String> hosts = new HashSet<String>();
        ClusterTopology global = this.globalTopology();
        if (global != null) {
            global.nodes().forEach(node -> hosts.add(node.host()));
        }
        for (ClusterTopologyWithBucket bucket : this.bucketTopologies()) {
            bucket.nodes().forEach(node -> hosts.add(node.host()));
        }
        return hosts;
    }

    public String toString() {
        return "ClusterConfig{bucketConfigs=" + this.bucketConfigs + ", globalConfig=" + this.globalConfig + '}';
    }

    public Map<ServiceType, Set<ClusterCapabilities>> clusterCapabilities() {
        Iterator<BucketConfig> iterator = this.bucketConfigs().values().iterator();
        if (iterator.hasNext()) {
            BucketConfig bc = iterator.next();
            return bc.clusterCapabilities();
        }
        return Collections.emptyMap();
    }
}

