/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint.http;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.util.UrlQueryStringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Stability.Internal
public class CoreHttpPath {
    private final String template;
    private final Map<String, String> params;
    private final String formatted;
    private static final Pattern PATH_PLACEHOLDER = Pattern.compile(Pattern.quote("{}"));

    public static String formatPath(String template, String ... args) {
        return CoreHttpPath.formatPath(template, Arrays.asList(args));
    }

    public static String formatPath(String template, List<String> args) {
        Iterator<String> i = args.iterator();
        Matcher m = PATH_PLACEHOLDER.matcher(template);
        StringBuffer result = new StringBuffer();
        while (m.find()) {
            if (!i.hasNext()) {
                throw new IllegalArgumentException("Too few arguments (" + args.size() + ") for format string: " + template);
            }
            m.appendReplacement(result, UrlQueryStringBuilder.urlEncode(i.next()));
        }
        m.appendTail(result);
        if (i.hasNext()) {
            throw new IllegalArgumentException("Too many arguments (" + args.size() + ") for format string: " + template);
        }
        return result.toString();
    }

    public static CoreHttpPath path(String template) {
        return new CoreHttpPath(template, Collections.emptyMap());
    }

    public static CoreHttpPath path(String template, Map<String, String> params) {
        return new CoreHttpPath(template, params);
    }

    private CoreHttpPath(String template, Map<String, String> params) {
        this.template = template.startsWith("/") ? template : "/" + template;
        this.params = Objects.requireNonNull(params);
        this.formatted = CoreHttpPath.resolve(this.template, params);
    }

    public String getTemplate() {
        return this.template;
    }

    public Map<String, String> getParams() {
        return Collections.unmodifiableMap(this.params);
    }

    public String format() {
        return this.formatted;
    }

    public CoreHttpPath plus(String subpath) {
        return this.plus(CoreHttpPath.path(subpath));
    }

    public CoreHttpPath plus(String subpathTemplate, Map<String, String> subpathParams) {
        return this.plus(CoreHttpPath.path(subpathTemplate, subpathParams));
    }

    public CoreHttpPath plus(CoreHttpPath subpath) {
        HashSet<String> commonParams = new HashSet<String>(this.params.keySet());
        commonParams.retainAll(subpath.params.keySet());
        if (!commonParams.isEmpty()) {
            throw new IllegalArgumentException("Subpath must not have parameter names in common with base path, but found: " + commonParams);
        }
        HashMap<String, String> mergedParams = new HashMap<String, String>(this.params);
        mergedParams.putAll(subpath.params);
        return new CoreHttpPath(this.template + subpath.template, mergedParams);
    }

    public String toString() {
        return "CoreHttpPath{template='" + this.template + '\'' + ", params=" + this.params + ", formatted='" + this.formatted + '\'' + '}';
    }

    private static String resolve(String template, Map<String, String> params) {
        String resolved = template;
        for (Map.Entry<String, String> param : params.entrySet()) {
            String key = param.getKey();
            String value = UrlQueryStringBuilder.urlEncode(param.getValue());
            resolved = resolved.replace("{" + key + "}", value);
        }
        if (resolved.contains("{") && resolved.contains("}")) {
            throw new IllegalArgumentException("Path has unresolved placeholder: " + resolved);
        }
        return resolved;
    }
}

