/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.env;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.util.Validators;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import reactor.util.annotation.Nullable;

public class SeedNode {
    public static final Set<SeedNode> LOCALHOST = Collections.singleton(SeedNode.create("127.0.0.1"));
    private final String address;
    private final Optional<Integer> kvPort;
    private final Optional<Integer> clusterManagerPort;
    private final Optional<Integer> protostellarPort;

    public static SeedNode create(String address) {
        return SeedNode.create(address, Optional.empty(), Optional.empty());
    }

    public static SeedNode create(String address, Optional<Integer> kvPort, Optional<Integer> clusterManagerPort) {
        return new SeedNode(address, kvPort, clusterManagerPort, Optional.empty());
    }

    private SeedNode(String address, Optional<Integer> kvPort, Optional<Integer> clusterManagerPort, Optional<Integer> protostellarPort) {
        this.address = Validators.notNullOrEmpty(address, "Address");
        this.kvPort = Validators.notNull(kvPort, "KvPort");
        this.clusterManagerPort = Validators.notNull(clusterManagerPort, "ClusterManagerPort");
        this.protostellarPort = Validators.notNull(protostellarPort, "ProtostellarPort");
    }

    public SeedNode withKvPort(@Nullable Integer port) {
        return SeedNode.create(this.address(), Optional.ofNullable(port), this.clusterManagerPort());
    }

    public SeedNode withManagerPort(@Nullable Integer port) {
        return SeedNode.create(this.address(), this.kvPort(), Optional.ofNullable(port));
    }

    @Stability.Volatile
    public SeedNode withProtostellarPort(@Nullable Integer port) {
        return new SeedNode(this.address(), this.kvPort(), this.clusterManagerPort(), Optional.ofNullable(port));
    }

    public String address() {
        return this.address;
    }

    public Optional<Integer> kvPort() {
        return this.kvPort;
    }

    public Optional<Integer> clusterManagerPort() {
        return this.clusterManagerPort;
    }

    @Stability.Volatile
    public Optional<Integer> protostellarPort() {
        return this.protostellarPort;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SeedNode{").append("address='").append(this.address).append('\'');
        this.kvPort.ifPresent(port -> sb.append(", kvPort=").append(port));
        this.clusterManagerPort.ifPresent(port -> sb.append(", mgmtPort=").append(port));
        this.protostellarPort.ifPresent(port -> sb.append(", psPort=").append(port));
        return sb.append('}').toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SeedNode seedNode = (SeedNode)o;
        return Objects.equals(this.address, seedNode.address) && Objects.equals(this.kvPort, seedNode.kvPort) && Objects.equals(this.clusterManagerPort, seedNode.clusterManagerPort) && Objects.equals(this.protostellarPort, seedNode.protostellarPort);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.kvPort, this.clusterManagerPort, this.protostellarPort);
    }
}

