/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.io.netty.kv;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBufAllocator;
import com.couchbase.client.core.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.core.deps.io.netty.buffer.UnpooledByteBufAllocator;
import com.couchbase.client.core.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.core.deps.io.netty.channel.ChannelInboundHandlerAdapter;
import com.couchbase.client.core.endpoint.EndpointContext;
import com.couchbase.client.core.io.netty.kv.KeyValueChannelContext;
import com.couchbase.client.core.io.netty.kv.MemcacheProtocol;
import com.couchbase.client.core.io.netty.kv.sasl.SingleStepSaslAuthParameters;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.msg.BaseResponse;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.BaseKeyValueRequest;
import com.couchbase.client.core.retry.FailFastRetryStrategy;
import com.couchbase.client.core.util.CbThrowables;
import com.couchbase.client.core.util.SynchronousEventBus;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationRefreshHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationRefreshHandler.class);
    private final EndpointContext endpointContext;
    private ChannelHandlerContext ctx;
    private SynchronousEventBus.Subscription subscription;
    private boolean handshakeComplete;
    private boolean reauthenticateLaterWhenHandshakeCompletes;

    public AuthenticationRefreshHandler(EndpointContext endpointContext) {
        this.endpointContext = Objects.requireNonNull(endpointContext);
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) {
        this.ctx = Objects.requireNonNull(ctx);
        this.subscription = this.endpointContext.core().authenticationRefreshTriggers.subscribe(signal -> ctx.executor().submit(this::handleSignal));
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) {
        this.subscription.unsubscribe();
    }

    private void requireInEventLoop() {
        if (!this.ctx.executor().inEventLoop()) {
            throw new IllegalStateException("This method must only be called in the channel's event loop");
        }
    }

    private void handleSignal() {
        this.requireInEventLoop();
        if (this.handshakeComplete) {
            this.reauthenticate();
        } else {
            log.info("Deferring reauthentication until handshake completes. Channel: {}", (Object)RedactableArgument.redactSystem(this.ctx.channel()));
            this.reauthenticateLaterWhenHandshakeCompletes = true;
        }
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        ctx.fireChannelActive();
        this.handshakeComplete = true;
        if (this.reauthenticateLaterWhenHandshakeCompletes) {
            log.info("Immediately reauthenticating the channel because a new authenticator was provided during the handshake process. Channel: {}", (Object)RedactableArgument.redactSystem(ctx.channel()));
            this.reauthenticate();
        }
    }

    private void reauthenticate() {
        this.requireInEventLoop();
        SingleStepSaslAuthParameters params = this.endpointContext.authenticator().getSingleStepSaslAuthParameters();
        SingleStepAuthRequest req = new SingleStepAuthRequest(this.endpointContext, params);
        this.ctx.writeAndFlush(req).addListener(it -> {
            if (it.isSuccess()) {
                log.debug("Successfully wrote authentication refresh request to channel {}", (Object)RedactableArgument.redactSystem(this.ctx.channel()));
                return;
            }
            if (!this.ctx.channel().isActive()) {
                log.debug("Failed to write authentication refresh request, but that's probably okay because channel is inactive. Channel: {}", (Object)RedactableArgument.redactSystem(this.ctx.channel()), (Object)it.cause());
                return;
            }
            log.warn("Failed to write authentication refresh request to channel. Closing channel: {}", (Object)RedactableArgument.redactSystem(this.ctx.channel()), (Object)it.cause());
            this.ctx.channel().close();
        });
        ((CompletableFuture)req.response().thenAccept(response -> {
            if (!response.status().success()) {
                log.warn("Authentication refresh request failed with status {}; closing channel {}", (Object)response.status(), (Object)RedactableArgument.redactSystem(this.ctx.channel()));
                this.ctx.channel().close();
            } else {
                log.info("Authentication refresh succeeded for channel {}", (Object)RedactableArgument.redactSystem(this.ctx.channel()));
            }
        })).exceptionally(t -> {
            log.error("Authentication refresh threw an exception; closing channel {}", (Object)RedactableArgument.redactSystem(this.ctx.channel()), t);
            this.ctx.channel().close();
            throw CbThrowables.propagate(t);
        });
    }

    private static class SingleStepAuthRequest
    extends BaseKeyValueRequest<SingleStepAuthResponse> {
        private final SingleStepSaslAuthParameters params;

        protected SingleStepAuthRequest(CoreContext ctx, SingleStepSaslAuthParameters params) {
            super(Duration.ZERO, ctx, FailFastRetryStrategy.INSTANCE, null, null);
            this.params = Objects.requireNonNull(params);
        }

        @Override
        public ByteBuf encode(ByteBufAllocator alloc, int opaque, KeyValueChannelContext ctx) {
            ByteBuf key = Unpooled.copiedBuffer(this.params.mechanism().mech(), StandardCharsets.UTF_8);
            ByteBuf body = Unpooled.copiedBuffer(this.params.payload(), StandardCharsets.UTF_8);
            return MemcacheProtocol.request(UnpooledByteBufAllocator.DEFAULT, MemcacheProtocol.Opcode.SASL_AUTH, MemcacheProtocol.noDatatype(), MemcacheProtocol.noPartition(), opaque, MemcacheProtocol.noCas(), MemcacheProtocol.noExtras(), key, body);
        }

        @Override
        public SingleStepAuthResponse decode(ByteBuf response, KeyValueChannelContext ctx) {
            short statusCode = MemcacheProtocol.status(response);
            ResponseStatus status = statusCode == MemcacheProtocol.Status.AUTH_ERROR.status() ? ResponseStatus.NO_ACCESS : MemcacheProtocol.decodeStatus(statusCode);
            return new SingleStepAuthResponse(status);
        }
    }

    private static class SingleStepAuthResponse
    extends BaseResponse {
        protected SingleStepAuthResponse(ResponseStatus status) {
            super(status);
        }
    }
}

