/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.io.netty.kv;

import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonCreator;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonProperty;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonValue;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.DeserializationFeature;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.ObjectReader;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.couchbase.client.core.json.Mapper;
import java.io.IOException;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ErrorMap
implements Comparable<ErrorMap> {
    private static final Comparator<ErrorMap> naturalOrder = Comparator.comparingInt(ErrorMap::version).thenComparingInt(ErrorMap::revision);
    private static final ObjectReader objectReader = Mapper.reader().forType(ErrorMap.class).with(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL).without(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    private final int version;
    private final int revision;
    private final Map<Short, ErrorCode> errors;

    public static ErrorMap fromJson(byte[] jsonBytes) throws IOException {
        return (ErrorMap)objectReader.readValue(jsonBytes);
    }

    @JsonCreator
    public ErrorMap(@JsonProperty(value="version") int version, @JsonProperty(value="revision") int revision, @JsonProperty(value="errors") Map<String, ErrorCode> errors) {
        this.version = version;
        this.revision = revision;
        this.errors = ErrorMap.toShortKeys(errors);
    }

    private static Map<Short, ErrorCode> toShortKeys(Map<String, ErrorCode> errors) {
        HashMap<Short, ErrorCode> result = new HashMap<Short, ErrorCode>(errors.size());
        for (Map.Entry<String, ErrorCode> entry : errors.entrySet()) {
            result.put(Short.parseShort(entry.getKey(), 16), entry.getValue());
        }
        return result;
    }

    @Override
    public int compareTo(ErrorMap o) {
        return naturalOrder.compare(this, o);
    }

    public int version() {
        return this.version;
    }

    public int revision() {
        return this.revision;
    }

    public Map<Short, ErrorCode> errors() {
        return this.errors;
    }

    public String toString() {
        return "ErrorMap{version=" + this.version + ", revision=" + this.revision + ", errors=" + this.errors + '}';
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ErrorCode {
        private final String name;
        private final String description;
        private final Set<ErrorAttribute> attributes;
        private final RetrySpecification retrySpec;

        @JsonCreator
        public ErrorCode(@JsonProperty(value="name") String name, @JsonProperty(value="desc") String description, @JsonProperty(value="attrs") @JsonDeserialize(as=EnumSet.class) Set<ErrorAttribute> attributes, @JsonProperty(value="retry") RetrySpecification retrySpec) {
            this.name = name;
            this.description = description;
            this.attributes = attributes;
            this.retrySpec = retrySpec;
        }

        public String name() {
            return this.name;
        }

        public String description() {
            return this.description;
        }

        public Set<ErrorAttribute> attributes() {
            return this.attributes;
        }

        public RetrySpecification retrySpec() {
            return this.retrySpec;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("ErrorCode{");
            sb.append("name='" + this.name + '\'');
            sb.append(", description='" + this.description + '\'');
            sb.append(", attributes=" + this.attributes);
            if (this.retrySpec != null) {
                sb.append(", retryHint=" + this.retrySpec.toString());
            }
            sb.append("}");
            return sb.toString();
        }
    }

    public static enum RetryStrategy {
        EXPONENTIAL("exponential"),
        LINEAR("linear"),
        CONSTANT("constant");

        private final String strategy;

        private RetryStrategy(String strategy) {
            this.strategy = strategy;
        }

        @JsonValue
        public String strategy() {
            return this.strategy;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class RetrySpecification {
        private final RetryStrategy strategy;
        private final long interval;
        private final long after;
        private final long maxDuration;
        private final long ceil;

        @JsonCreator
        public RetrySpecification(@JsonProperty(value="strategy") RetryStrategy strategy, @JsonProperty(value="interval") int interval, @JsonProperty(value="after") int after, @JsonProperty(value="max-duration") int maxDuration, @JsonProperty(value="ceil") int ceil) {
            this.strategy = strategy;
            this.interval = interval;
            this.after = after;
            this.maxDuration = maxDuration;
            this.ceil = ceil;
        }

        public RetryStrategy strategy() {
            return this.strategy;
        }

        public long interval() {
            return this.interval;
        }

        public long after() {
            return this.after;
        }

        public long maxDuration() {
            return this.maxDuration;
        }

        public long ceil() {
            return this.ceil;
        }

        public String toString() {
            return "Retry{strategy=" + (Object)((Object)this.strategy()) + ", interval=" + this.interval() + ", after=" + this.after() + ", max-duration=" + this.maxDuration() + ", ceil=" + this.ceil() + "}";
        }
    }

    public static enum ErrorAttribute {
        SUCCESS("success"),
        ITEM_ONLY("item-only"),
        INVALID_INPUT("invalid-input"),
        FETCH_CONFIG("fetch-config"),
        CONN_STATE_INVALIDATED("conn-state-invalidated"),
        AUTH("auth"),
        SPECIAL_HANDLING("special-handling"),
        SUPPORT("support"),
        TEMP("temp"),
        INTERNAL("internal"),
        RETRY_NOW("retry-now"),
        RETRY_LATER("retry-later"),
        SUBDOC("subdoc"),
        DCP("dcp"),
        AUTO_RETRY("auto-retry"),
        ITEM_LOCKED("item-locked"),
        ITEM_DELETED("item-deleted");

        private final String raw;

        private ErrorAttribute(String raw) {
            this.raw = raw;
        }

        @JsonValue
        public String raw() {
            return this.raw;
        }
    }
}

