/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.io.netty.kv.sasl;

import com.couchbase.client.core.annotation.Stability;
import java.util.Objects;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@Stability.Internal
@NullMarked
abstract class InitialResponseSaslClient
implements SaslClient {
    private final CallbackHandler callbackHandler;
    protected final @Nullable String authorizationId;
    private boolean complete;

    public InitialResponseSaslClient(@Nullable String authorizationId, CallbackHandler callbackHandler) {
        this.authorizationId = authorizationId;
        this.callbackHandler = Objects.requireNonNull(callbackHandler);
    }

    @Override
    public boolean hasInitialResponse() {
        return true;
    }

    @Override
    public byte[] evaluateChallenge(byte[] challenge) throws SaslException {
        if (this.isComplete()) {
            throw new IllegalStateException("Can't call evaluateChallenge after authentication is complete.");
        }
        this.complete = true;
        return this.getInitialResponse(this.callbackHandler);
    }

    abstract byte[] getInitialResponse(CallbackHandler var1) throws SaslException;

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        this.requireComplete("unwrap");
        throw new IllegalStateException(this.getMechanismName() + " has neither integrity nor privacy");
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        this.requireComplete("wrap");
        throw new IllegalStateException(this.getMechanismName() + " has neither integrity nor privacy");
    }

    @Override
    public @Nullable Object getNegotiatedProperty(String propName) {
        this.requireComplete("getNegotiatedProperty");
        return null;
    }

    private void requireComplete(String methodName) {
        if (!this.isComplete()) {
            throw new IllegalStateException("Can't call " + methodName + " before authentication is complete.");
        }
    }

    @Override
    public void dispose() throws SaslException {
    }
}

