/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.transaction.support;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.tracing.RequestTracerAndDecorator;
import com.couchbase.client.core.cnc.tracing.TracingAttribute;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.transaction.CoreTransactionAttemptContext;
import com.couchbase.client.core.transaction.support.SpanWrapper;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class SpanWrapperUtil {
    private SpanWrapperUtil() {
    }

    public static SpanWrapper createOp(@Nullable CoreTransactionAttemptContext ctx, RequestTracerAndDecorator tracer, @Nullable CollectionIdentifier collection, @Nullable String id, String op, @Nullable SpanWrapper attemptSpan) {
        SpanWrapper out = SpanWrapper.create(tracer.requestTracer, op, attemptSpan);
        if (!out.isInternal()) {
            tracer.decorator.provideLowCardinalityAttr(TracingAttribute.OPERATION, out.span(), op);
            return SpanWrapperUtil.setAttributes(out, tracer, ctx, collection, id);
        }
        return out;
    }

    public static SpanWrapper addOperationAttribute(RequestTracerAndDecorator tracer, SpanWrapper span, String op) {
        if (!span.isInternal()) {
            tracer.decorator.provideLowCardinalityAttr(TracingAttribute.OPERATION, span.span(), op);
        }
        return span;
    }

    public static SpanWrapper setAttributes(SpanWrapper out, RequestTracerAndDecorator tracer, @Nullable CoreTransactionAttemptContext ctx, @Nullable CollectionIdentifier collection, @Nullable String id) {
        if (!out.isInternal()) {
            tracer.decorator.provideLowCardinalityAttr(TracingAttribute.SERVICE, out.span(), "transactions");
            if (ctx != null) {
                tracer.decorator.provideAttr(TracingAttribute.TRANSACTION_ID, out.span(), ctx.transactionId());
                tracer.decorator.provideAttr(TracingAttribute.TRANSACTION_ATTEMPT_ID, out.span(), ctx.attemptId());
            }
            if (collection != null) {
                tracer.decorator.provideLowCardinalityAttr(TracingAttribute.BUCKET_NAME, out.span(), collection.bucket());
                tracer.decorator.provideAttr(TracingAttribute.SCOPE_NAME, out.span(), collection.scope().orElse("_default"));
                tracer.decorator.provideAttr(TracingAttribute.COLLECTION_NAME, out.span(), collection.collection().orElse("_default"));
            }
            if (id != null) {
                tracer.decorator.provideAttr(TracingAttribute.DOCUMENT_ID, out.span(), id);
            }
        }
        return out;
    }
}

