/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynchronousEventBus<T> {
    private static final Logger log = LoggerFactory.getLogger(SynchronousEventBus.class);
    private final List<Consumer<T>> listeners = new ArrayList<Consumer<T>>();

    public synchronized Subscription subscribe(Consumer<T> listener) {
        Objects.requireNonNull(listener);
        this.listeners.add(listener);
        return new SubscriptionImpl(listener);
    }

    private synchronized void remove(Consumer<T> listener) {
        this.listeners.remove(listener);
    }

    public synchronized void publish(T event) {
        for (Consumer<T> listener : this.listeners) {
            try {
                listener.accept(event);
            }
            catch (RuntimeException t) {
                log.error("SynchronousEventBus subscriber threw exception.", (Throwable)t);
            }
        }
    }

    private class SubscriptionImpl
    implements Subscription {
        private final Consumer<T> callback;

        public SubscriptionImpl(Consumer<T> listener) {
            this.callback = Objects.requireNonNull(listener);
        }

        @Override
        public void unsubscribe() {
            SynchronousEventBus.this.remove(this.callback);
        }
    }

    public static interface Subscription {
        public void unsubscribe();
    }
}

