/*
 * Copyright 2014 The Netty Project
 *
 * The Netty Project licenses this file to you under the Apache License,
 * version 2.0 (the "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at:
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */
package com.couchbase.client.core.deps.io.netty.handler.codec.http.websocketx.extensions;

import com.couchbase.client.core.deps.io.netty.handler.codec.MessageToMessageEncoder;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.websocketx.WebSocketFrame;

/**
 * Convenient class for <tt>com.couchbase.client.core.deps.io.netty.handler.codec.http.websocketx.extensions.WebSocketExtension</tt> encoder.
 */
public abstract class WebSocketExtensionEncoder extends MessageToMessageEncoder<WebSocketFrame> {
    public WebSocketExtensionEncoder() {
        super(WebSocketFrame.class);
    }
}
