/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.eventing;

import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.manager.eventing.EventingFunctionDcpBoundary;
import com.couchbase.client.java.manager.eventing.EventingFunctionDeploymentStatus;
import com.couchbase.client.java.manager.eventing.EventingFunctionLanguageCompatibility;
import com.couchbase.client.java.manager.eventing.EventingFunctionLogLevel;
import com.couchbase.client.java.manager.eventing.EventingFunctionProcessingStatus;
import com.couchbase.client.java.query.QueryScanConsistency;
import java.time.Duration;
import java.util.List;

public class EventingFunctionSettings {
    private final EventingFunctionProcessingStatus processingStatus;
    private final EventingFunctionDeploymentStatus deploymentStatus;
    private final long cppWorkerThreadCount;
    private final EventingFunctionDcpBoundary dcpStreamBoundary;
    private final String description;
    private final EventingFunctionLogLevel logLevel;
    private final EventingFunctionLanguageCompatibility languageCompatibility;
    private final Duration executionTimeout;
    private final long lcbInstCapacity;
    private final long lcbRetryCount;
    private final Duration lcbTimeout;
    private final QueryScanConsistency queryConsistency;
    private final long numTimerPartitions;
    private final long sockBatchSize;
    private final Duration tickDuration;
    private final long timerContextSize;
    private final String userPrefix;
    private final long bucketCacheSize;
    private final long bucketCacheAge;
    private final long curlMaxAllowedRespSize;
    private final long workerCount;
    private final boolean queryPrepareAll;
    private final List<String> handlerHeaders;
    private final List<String> handlerFooters;
    private final boolean enableAppLogRotation;
    private final String appLogDir;
    private final long appLogMaxSize;
    private final long appLogMaxFiles;
    private final Duration checkpointInterval;

    public static EventingFunctionSettings create() {
        return EventingFunctionSettings.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private EventingFunctionSettings(Builder builder) {
        this.processingStatus = builder.processingStatus;
        this.deploymentStatus = builder.deploymentStatus;
        this.cppWorkerThreadCount = builder.cppWorkerThreadCount;
        this.dcpStreamBoundary = builder.dcpStreamBoundary;
        this.description = builder.description;
        this.logLevel = builder.logLevel;
        this.languageCompatibility = builder.languageCompatibility;
        this.executionTimeout = builder.executionTimeout;
        this.lcbInstCapacity = builder.lcbInstCapacity;
        this.lcbRetryCount = builder.lcbRetryCount;
        this.lcbTimeout = builder.lcbTimeout;
        this.queryConsistency = builder.queryConsistency;
        this.numTimerPartitions = builder.numTimerPartitions;
        this.sockBatchSize = builder.sockBatchSize;
        this.tickDuration = builder.tickDuration;
        this.timerContextSize = builder.timerContextSize;
        this.userPrefix = builder.userPrefix;
        this.bucketCacheSize = builder.bucketCacheSize;
        this.bucketCacheAge = builder.bucketCacheAge;
        this.curlMaxAllowedRespSize = builder.curlMaxAllowedRespSize;
        this.workerCount = builder.workerCount;
        this.queryPrepareAll = builder.queryPrepareAll;
        this.handlerHeaders = builder.handlerHeaders;
        this.handlerFooters = builder.handlerFooters;
        this.enableAppLogRotation = builder.enableAppLogRotation;
        this.appLogDir = builder.appLogDir;
        this.appLogMaxSize = builder.appLogMaxSize;
        this.appLogMaxFiles = builder.appLogMaxFiles;
        this.checkpointInterval = builder.checkpointInterval;
    }

    public EventingFunctionProcessingStatus processingStatus() {
        return this.processingStatus;
    }

    public EventingFunctionDeploymentStatus deploymentStatus() {
        return this.deploymentStatus;
    }

    public long cppWorkerThreadCount() {
        return this.cppWorkerThreadCount;
    }

    public EventingFunctionDcpBoundary dcpStreamBoundary() {
        return this.dcpStreamBoundary;
    }

    public String description() {
        return this.description;
    }

    public EventingFunctionLogLevel logLevel() {
        return this.logLevel;
    }

    public EventingFunctionLanguageCompatibility languageCompatibility() {
        return this.languageCompatibility;
    }

    public Duration executionTimeout() {
        return this.executionTimeout;
    }

    public long lcbInstCapacity() {
        return this.lcbInstCapacity;
    }

    public long lcbRetryCount() {
        return this.lcbRetryCount;
    }

    public Duration lcbTimeout() {
        return this.lcbTimeout;
    }

    public QueryScanConsistency queryConsistency() {
        return this.queryConsistency;
    }

    public long numTimerPartitions() {
        return this.numTimerPartitions;
    }

    public long sockBatchSize() {
        return this.sockBatchSize;
    }

    public Duration tickDuration() {
        return this.tickDuration;
    }

    public long timerContextSize() {
        return this.timerContextSize;
    }

    public String userPrefix() {
        return this.userPrefix;
    }

    public long bucketCacheSize() {
        return this.bucketCacheSize;
    }

    public long bucketCacheAge() {
        return this.bucketCacheAge;
    }

    public long curlMaxAllowedRespSize() {
        return this.curlMaxAllowedRespSize;
    }

    public long workerCount() {
        return this.workerCount;
    }

    public boolean queryPrepareAll() {
        return this.queryPrepareAll;
    }

    public List<String> handlerHeaders() {
        return this.handlerHeaders;
    }

    public List<String> handlerFooters() {
        return this.handlerFooters;
    }

    public boolean enableAppLogRotation() {
        return this.enableAppLogRotation;
    }

    public String appLogDir() {
        return this.appLogDir;
    }

    public long appLogMaxSize() {
        return this.appLogMaxSize;
    }

    public long appLogMaxFiles() {
        return this.appLogMaxFiles;
    }

    public Duration checkpointInterval() {
        return this.checkpointInterval;
    }

    public String toString() {
        return "EventingFunctionSettings{cppWorkerThreadCount=" + this.cppWorkerThreadCount + ", dcpStreamBoundary='" + (Object)((Object)this.dcpStreamBoundary) + '\'' + ", description='" + this.description + '\'' + ", logLevel='" + (Object)((Object)this.logLevel) + '\'' + ", languageCompatibility='" + (Object)((Object)this.languageCompatibility) + '\'' + ", executionTimeout=" + this.executionTimeout + ", lcbInstCapacity=" + this.lcbInstCapacity + ", lcbRetryCount=" + this.lcbRetryCount + ", lcbTimeout=" + this.lcbTimeout + ", queryConsistency=" + (Object)((Object)this.queryConsistency) + ", numTimerPartitions=" + this.numTimerPartitions + ", sockBatchSize=" + this.sockBatchSize + ", tickDuration=" + this.tickDuration + ", timerContextSize=" + this.timerContextSize + ", userPrefix='" + this.userPrefix + '\'' + ", bucketCacheSize=" + this.bucketCacheSize + ", bucketCacheAge=" + this.bucketCacheAge + ", curlMaxAllowedRespSize=" + this.curlMaxAllowedRespSize + ", workerCount=" + this.workerCount + ", queryPrepareAll=" + this.queryPrepareAll + ", handlerHeaders=" + this.handlerHeaders + ", handlerFooters=" + this.handlerFooters + ", enableAppLogRotation=" + this.enableAppLogRotation + ", appLogDir='" + this.appLogDir + '\'' + ", appLogMaxSize=" + this.appLogMaxSize + ", appLogMaxFiles=" + this.appLogMaxFiles + ", checkpointInterval=" + this.checkpointInterval + '}';
    }

    public static class Builder {
        private EventingFunctionProcessingStatus processingStatus;
        private EventingFunctionDeploymentStatus deploymentStatus;
        private long cppWorkerThreadCount;
        private EventingFunctionDcpBoundary dcpStreamBoundary;
        private String description;
        private EventingFunctionLogLevel logLevel;
        private EventingFunctionLanguageCompatibility languageCompatibility;
        private Duration executionTimeout;
        private long lcbInstCapacity;
        private long lcbRetryCount;
        private Duration lcbTimeout;
        private QueryScanConsistency queryConsistency;
        private long numTimerPartitions;
        private long sockBatchSize;
        private Duration tickDuration;
        private long timerContextSize;
        private String userPrefix;
        private long bucketCacheSize;
        private long bucketCacheAge;
        private long curlMaxAllowedRespSize;
        private long workerCount;
        private boolean queryPrepareAll;
        private List<String> handlerHeaders;
        private List<String> handlerFooters;
        private boolean enableAppLogRotation;
        private String appLogDir;
        private long appLogMaxSize;
        private long appLogMaxFiles;
        private Duration checkpointInterval;

        Builder processingStatus(EventingFunctionProcessingStatus processingStatus) {
            this.processingStatus = (EventingFunctionProcessingStatus)((Object)Validators.notNull((Object)((Object)processingStatus), (String)"ProcessingStatus"));
            return this;
        }

        Builder deploymentStatus(EventingFunctionDeploymentStatus deploymentStatus) {
            this.deploymentStatus = (EventingFunctionDeploymentStatus)((Object)Validators.notNull((Object)((Object)deploymentStatus), (String)"DeploymentStatus"));
            return this;
        }

        public Builder checkpointInterval(Duration checkpointInterval) {
            this.checkpointInterval = (Duration)Validators.notNull((Object)checkpointInterval, (String)"CheckpointInterval");
            return this;
        }

        public Builder appLogMaxFiles(long appLogMaxFiles) {
            this.appLogMaxFiles = appLogMaxFiles;
            return this;
        }

        public Builder appLogMaxSize(long appLogMaxSize) {
            this.appLogMaxSize = appLogMaxSize;
            return this;
        }

        public Builder appLogDir(String appLogDir) {
            this.appLogDir = Validators.notNullOrEmpty((String)appLogDir, (String)"AppLogDir");
            return this;
        }

        public Builder enableAppLogRotation(boolean enableAppLogRotation) {
            this.enableAppLogRotation = enableAppLogRotation;
            return this;
        }

        public Builder handlerFooters(List<String> handlerFooters) {
            this.handlerFooters = (List)Validators.notNull(handlerFooters, (String)"HandlerFooters");
            return this;
        }

        public Builder handlerHeaders(List<String> handlerHeaders) {
            this.handlerHeaders = (List)Validators.notNull(handlerHeaders, (String)"HandlerHeaders");
            return this;
        }

        public Builder queryPrepareAll(boolean queryPrepareAll) {
            this.queryPrepareAll = queryPrepareAll;
            return this;
        }

        public Builder workerCount(long workerCount) {
            this.workerCount = workerCount;
            return this;
        }

        public Builder cppWorkerThreadCount(long cppWorkerThreadCount) {
            this.cppWorkerThreadCount = cppWorkerThreadCount;
            return this;
        }

        public Builder dcpStreamBoundary(EventingFunctionDcpBoundary dcpStreamBoundary) {
            this.dcpStreamBoundary = (EventingFunctionDcpBoundary)((Object)Validators.notNull((Object)((Object)dcpStreamBoundary), (String)"DcpStreamBoundary"));
            return this;
        }

        public Builder description(String description) {
            this.description = (String)Validators.notNull((Object)description, (String)"Description");
            return this;
        }

        public Builder logLevel(EventingFunctionLogLevel logLevel) {
            this.logLevel = (EventingFunctionLogLevel)((Object)Validators.notNull((Object)((Object)logLevel), (String)"LogLevel"));
            return this;
        }

        public Builder languageCompatibility(EventingFunctionLanguageCompatibility languageCompatibility) {
            this.languageCompatibility = (EventingFunctionLanguageCompatibility)((Object)Validators.notNull((Object)((Object)languageCompatibility), (String)"EventingFunctionLanguageCompatibility"));
            return this;
        }

        public Builder executionTimeout(Duration executionTimeout) {
            this.executionTimeout = (Duration)Validators.notNull((Object)executionTimeout, (String)"ExecutionTimeout");
            return this;
        }

        public Builder lcbInstCapacity(long lcbInstCapacity) {
            this.lcbInstCapacity = lcbInstCapacity;
            return this;
        }

        public Builder lcbRetryCount(long lcbRetryCount) {
            this.lcbRetryCount = lcbRetryCount;
            return this;
        }

        public Builder lcbTimeout(Duration lcbTimeout) {
            this.lcbTimeout = (Duration)Validators.notNull((Object)lcbTimeout, (String)"LcbTimeout");
            return this;
        }

        public Builder queryConsistency(QueryScanConsistency queryConsistency) {
            this.queryConsistency = (QueryScanConsistency)((Object)Validators.notNull((Object)((Object)queryConsistency), (String)"QueryConsistency"));
            return this;
        }

        public Builder numTimerPartitions(long numTimerPartitions) {
            this.numTimerPartitions = numTimerPartitions;
            return this;
        }

        public Builder sockBatchSize(long sockBatchSize) {
            this.sockBatchSize = sockBatchSize;
            return this;
        }

        public Builder tickDuration(Duration tickDuration) {
            this.tickDuration = (Duration)Validators.notNull((Object)tickDuration, (String)"Tick Duration");
            return this;
        }

        public Builder timerContextSize(long timerContextSize) {
            this.timerContextSize = timerContextSize;
            return this;
        }

        public Builder userPrefix(String userPrefix) {
            this.userPrefix = Validators.notNullOrEmpty((String)userPrefix, (String)"User Prefix");
            return this;
        }

        public Builder bucketCacheSize(long bucketCacheSize) {
            this.bucketCacheSize = bucketCacheSize;
            return this;
        }

        public Builder bucketCacheAge(long bucketCacheAge) {
            this.bucketCacheAge = bucketCacheAge;
            return this;
        }

        public Builder curlMaxAllowedRespSize(long curlMaxAllowedRespSize) {
            this.curlMaxAllowedRespSize = curlMaxAllowedRespSize;
            return this;
        }

        public EventingFunctionSettings build() {
            return new EventingFunctionSettings(this);
        }
    }
}

