/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.transactions.getmulti;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.DocumentNotFoundException;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.java.codec.TypeRef;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.transactions.getmulti.TransactionGetMultiSpecResult;
import java.util.List;
import java.util.Objects;

@Stability.Uncommitted
public class TransactionGetMultiResult {
    private final List<TransactionGetMultiSpecResult> results;

    @Stability.Internal
    public TransactionGetMultiResult(List<TransactionGetMultiSpecResult> results) {
        this.results = Objects.requireNonNull(results);
    }

    private void validateResultIndex(int specIndex) {
        if (specIndex < 0) {
            throw new InvalidArgumentException("Index must be greater or equal to 0.", null, null);
        }
        if (specIndex >= this.results.size()) {
            throw new InvalidArgumentException("Index must be less than the number of results.", null, null);
        }
    }

    public boolean exists(int specIndex) {
        this.validateResultIndex(specIndex);
        return this.results.get(specIndex).exists();
    }

    private TransactionGetMultiSpecResult get(int specIndex) {
        if (!this.exists(specIndex)) {
            throw new DocumentNotFoundException(null);
        }
        return this.results.get(specIndex);
    }

    public JsonObject contentAsObject(int specIndex) {
        return this.get(specIndex).get().contentAsObject();
    }

    public <T> T contentAs(int specIndex, Class<T> target) {
        return this.get(specIndex).get().contentAs(target);
    }

    public <T> T contentAs(int specIndex, TypeRef<T> target) {
        return this.get(specIndex).get().contentAs(target);
    }

    public byte[] contentAsBytes(int specIndex) {
        return this.get(specIndex).get().contentAsBytes();
    }

    public int size() {
        return this.results.size();
    }
}

