/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.search;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.search.CoreHighlightStyle;
import com.couchbase.client.core.api.search.CoreSearchKeyset;
import com.couchbase.client.core.api.search.CoreSearchScanConsistency;
import com.couchbase.client.core.api.search.facet.CoreSearchFacet;
import com.couchbase.client.core.api.search.sort.CoreSearchSort;
import com.couchbase.client.core.api.shared.CoreMutationState;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.error.InvalidArgumentException;
import java.util.List;
import java.util.Map;
import reactor.util.annotation.Nullable;

@Stability.Internal
public interface CoreSearchOptions {
    public List<String> collections();

    @Nullable
    public CoreSearchScanConsistency consistency();

    @Nullable
    public CoreMutationState consistentWith();

    @Nullable
    public Boolean disableScoring();

    @Nullable
    public Boolean explain();

    public Map<String, CoreSearchFacet> facets();

    public List<String> fields();

    public List<String> highlightFields();

    @Nullable
    public CoreHighlightStyle highlightStyle();

    @Nullable
    public Integer limit();

    @Nullable
    public JsonNode raw();

    @Nullable
    public Integer skip();

    @Nullable
    default public CoreSearchKeyset searchBefore() {
        return null;
    }

    @Nullable
    default public CoreSearchKeyset searchAfter() {
        return null;
    }

    public List<CoreSearchSort> sort();

    @Nullable
    public Boolean includeLocations();

    public CoreCommonOptions commonOptions();

    default public void validate() {
        int pageOptions = 0;
        if (this.skip() != null) {
            ++pageOptions;
        }
        if (this.searchBefore() != null) {
            ++pageOptions;
        }
        if (this.searchAfter() != null) {
            ++pageOptions;
        }
        if (pageOptions > 1) {
            throw InvalidArgumentException.fromMessage("Must specify no more than one of 'skip', 'searchBefore', or 'searchAfter'.");
        }
    }
}

