/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.search.queries;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.search.CoreSearchQuery;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.error.FeatureNotAvailableException;
import com.couchbase.client.protostellar.search.v1.DateRangeQuery;
import com.couchbase.client.protostellar.search.v1.Query;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class CoreDateRangeQuery
extends CoreSearchQuery {
    @Nullable
    private final String start;
    @Nullable
    private final String end;
    @Nullable
    private final Boolean inclusiveStart;
    @Nullable
    private final Boolean inclusiveEnd;
    @Nullable
    private final String dateTimeParser;
    @Nullable
    private final String field;

    public CoreDateRangeQuery(@Nullable String start, @Nullable String end, @Nullable Boolean inclusiveStart, @Nullable Boolean inclusiveEnd, @Nullable String dateTimeParser, @Nullable String field, @Nullable Double boost) {
        super(boost);
        if (start == null && end == null) {
            throw new NullPointerException("DateRangeQuery needs at least one of start or end");
        }
        this.start = start;
        this.end = end;
        this.inclusiveStart = inclusiveStart;
        this.inclusiveEnd = inclusiveEnd;
        this.dateTimeParser = dateTimeParser;
        this.field = field;
    }

    @Override
    protected void injectParams(ObjectNode input) {
        if (this.start != null) {
            input.put("start", this.start);
            if (this.inclusiveStart != null) {
                input.put("inclusive_start", this.inclusiveStart);
            }
        }
        if (this.end != null) {
            input.put("end", this.end);
            if (this.inclusiveEnd != null) {
                input.put("inclusive_end", this.inclusiveEnd);
            }
        }
        if (this.dateTimeParser != null) {
            input.put("datetime_parser", this.dateTimeParser);
        }
        if (this.field != null) {
            input.put("field", this.field);
        }
    }

    @Override
    public Query asProtostellar() {
        DateRangeQuery.Builder builder = DateRangeQuery.newBuilder();
        if (this.start != null) {
            builder.setStartDate(this.start);
            if (this.inclusiveStart != null) {
                throw new FeatureNotAvailableException("inclusiveStart is not currently supported in DateRangeQuery for couchbase2");
            }
        }
        if (this.end != null) {
            builder.setEndDate(this.end);
            if (this.inclusiveEnd != null) {
                throw new FeatureNotAvailableException("inclusiveStart is not currently supported in DateRangeQuery for couchbase2");
            }
        }
        if (this.dateTimeParser != null) {
            builder.setDateTimeParser(this.dateTimeParser);
        }
        if (this.field != null) {
            builder.setField(this.field);
        }
        if (this.boost != null) {
            builder.setBoost(this.boost.floatValue());
        }
        return Query.newBuilder().setDateRangeQuery(builder).build();
    }
}

