/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.search.result;

import com.couchbase.client.core.annotation.Stability;
import java.time.Duration;

@Stability.Internal
public class CoreSearchMetrics {
    private final Duration took;
    private final long totalRows;
    private final double maxScore;
    private final long successPartitionCount;
    private final long errorPartitionCount;

    public CoreSearchMetrics(Duration took, long totalRows, double maxScore, long successPartitionCount, long errorPartitionCount) {
        this.took = took;
        this.totalRows = totalRows;
        this.maxScore = maxScore;
        this.successPartitionCount = successPartitionCount;
        this.errorPartitionCount = errorPartitionCount;
    }

    public Duration took() {
        return this.took;
    }

    public long totalRows() {
        return this.totalRows;
    }

    public double maxScore() {
        return this.maxScore;
    }

    public long successPartitionCount() {
        return this.successPartitionCount;
    }

    public long errorPartitionCount() {
        return this.errorPartitionCount;
    }

    public long totalPartitionCount() {
        return this.successPartitionCount + this.errorPartitionCount;
    }

    public String toString() {
        return "CoreSearchMetrics{took=" + this.took + ", totalRows=" + this.totalRows + ", maxScore=" + this.maxScore + ", successPartitionCount=" + this.successPartitionCount + ", errorPartitionCount=" + this.errorPartitionCount + '}';
    }
}

