/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.cnc.events.core;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.cnc.AbstractEvent;
import com.couchbase.client.core.cnc.Context;
import com.couchbase.client.core.cnc.Event;
import com.couchbase.client.core.env.CoreEnvironment;
import com.couchbase.client.core.env.SeedNode;
import com.couchbase.client.core.util.ConnectionString;
import java.time.Duration;
import java.util.Map;
import java.util.Set;
import reactor.util.annotation.Nullable;

public class CoreCreatedEvent
extends AbstractEvent {
    private final CoreEnvironment environment;

    public CoreCreatedEvent(CoreContext context, CoreEnvironment environment, Set<SeedNode> seedNodes, int numCoreInstances, @Nullable ConnectionString connectionString) {
        super(Event.Severity.INFO, Event.Category.CORE, Duration.ZERO, CoreCreatedEvent.enrichContext(context, numCoreInstances, connectionString));
        this.environment = environment;
    }

    private static Context enrichContext(CoreContext context, final int numCoreInstances, final @Nullable ConnectionString connectionString) {
        return new CoreContext(context.core(), context.id(), context.environment(), context.authenticator()){

            @Override
            public void injectExportableParams(Map<String, Object> input) {
                super.injectExportableParams(input);
                input.put("numCoreInstances", numCoreInstances);
                if (connectionString != null) {
                    input.put("connectionString", connectionString.original());
                }
            }
        };
    }

    @Override
    public String description() {
        return this.environment.exportAsString(Context.ExportFormat.JSON);
    }
}

