/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.config;

import com.couchbase.client.core.config.PortInfo;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonCreator;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonProperty;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.service.ServiceType;
import java.util.HashMap;
import java.util.Map;

@Deprecated
@JsonIgnoreProperties(ignoreUnknown=true)
public class AlternateAddress {
    private final String hostname;
    private final Map<ServiceType, Integer> directServices;
    private final Map<ServiceType, Integer> sslServices;

    @JsonCreator
    public AlternateAddress(@JsonProperty(value="hostname") String hostname, @JsonProperty(value="ports") Map<String, Integer> ports) {
        try {
            this.hostname = hostname;
        }
        catch (Exception e) {
            throw new CouchbaseException("Could not analyze hostname from config.", e);
        }
        this.directServices = new HashMap<ServiceType, Integer>();
        this.sslServices = new HashMap<ServiceType, Integer>();
        if (ports != null && !ports.isEmpty()) {
            PortInfo.extractPorts(ports, this.directServices, this.sslServices);
        }
    }

    public String hostname() {
        return this.hostname;
    }

    public Map<ServiceType, Integer> services() {
        return this.directServices;
    }

    public Map<ServiceType, Integer> sslServices() {
        return this.sslServices;
    }

    public String toString() {
        return "DefaultAlternateAddress{hostname=" + this.hostname + ", directServices=" + this.directServices + ", sslServices=" + this.sslServices + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlternateAddress that = (AlternateAddress)o;
        if (this.hostname != null ? !this.hostname.equals(that.hostname) : that.hostname != null) {
            return false;
        }
        if (this.directServices != null ? !this.directServices.equals(that.directServices) : that.directServices != null) {
            return false;
        }
        return this.sslServices != null ? this.sslServices.equals(that.sslServices) : that.sslServices == null;
    }

    public int hashCode() {
        int result = this.hostname != null ? this.hostname.hashCode() : 0;
        result = 31 * result + (this.directServices != null ? this.directServices.hashCode() : 0);
        result = 31 * result + (this.sslServices != null ? this.sslServices.hashCode() : 0);
        return result;
    }
}

