/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.deps.io.grpc.protobuf;

import com.couchbase.client.core.deps.com.google.common.base.Preconditions;
import com.couchbase.client.core.deps.com.google.rpc.Status;
import com.couchbase.client.core.deps.io.grpc.ExperimentalApi;
import com.couchbase.client.core.deps.io.grpc.Metadata;
import com.couchbase.client.core.deps.io.grpc.Status;
import com.couchbase.client.core.deps.io.grpc.StatusException;
import com.couchbase.client.core.deps.io.grpc.StatusRuntimeException;
import com.couchbase.client.core.deps.io.grpc.protobuf.lite.ProtoLiteUtils;
import javax.annotation.Nullable;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4695")
public final class StatusProto {
    private static final Metadata.Key<com.couchbase.client.core.deps.com.google.rpc.Status> STATUS_DETAILS_KEY = Metadata.Key.of("grpc-status-details-bin", ProtoLiteUtils.metadataMarshaller(com.couchbase.client.core.deps.com.google.rpc.Status.getDefaultInstance()));

    private StatusProto() {
    }

    public static StatusRuntimeException toStatusRuntimeException(com.couchbase.client.core.deps.com.google.rpc.Status statusProto) {
        return StatusProto.toStatus(statusProto).asRuntimeException(StatusProto.toMetadata(statusProto));
    }

    public static StatusRuntimeException toStatusRuntimeException(com.couchbase.client.core.deps.com.google.rpc.Status statusProto, Metadata metadata) {
        return StatusProto.toStatus(statusProto).asRuntimeException(StatusProto.toMetadata(statusProto, metadata));
    }

    public static StatusException toStatusException(com.couchbase.client.core.deps.com.google.rpc.Status statusProto) {
        return StatusProto.toStatus(statusProto).asException(StatusProto.toMetadata(statusProto));
    }

    public static StatusException toStatusException(com.couchbase.client.core.deps.com.google.rpc.Status statusProto, Metadata metadata) {
        return StatusProto.toStatus(statusProto).asException(StatusProto.toMetadata(statusProto, metadata));
    }

    public static StatusException toStatusException(com.couchbase.client.core.deps.com.google.rpc.Status statusProto, Metadata metadata, Throwable cause) {
        return StatusProto.toStatus(statusProto).withCause(cause).asException(StatusProto.toMetadata(statusProto, metadata));
    }

    private static Status toStatus(com.couchbase.client.core.deps.com.google.rpc.Status statusProto) {
        Status status = Status.fromCodeValue(statusProto.getCode());
        Preconditions.checkArgument(status.getCode().value() == statusProto.getCode(), "invalid status code");
        return status.withDescription(statusProto.getMessage());
    }

    private static Metadata toMetadata(com.couchbase.client.core.deps.com.google.rpc.Status statusProto) {
        Metadata metadata = new Metadata();
        metadata.put(STATUS_DETAILS_KEY, statusProto);
        return metadata;
    }

    private static Metadata toMetadata(com.couchbase.client.core.deps.com.google.rpc.Status statusProto, Metadata metadata) {
        Preconditions.checkNotNull(metadata, "metadata must not be null");
        metadata.discardAll(STATUS_DETAILS_KEY);
        metadata.put(STATUS_DETAILS_KEY, statusProto);
        return metadata;
    }

    @Nullable
    public static com.couchbase.client.core.deps.com.google.rpc.Status fromThrowable(Throwable t) {
        for (Throwable cause = Preconditions.checkNotNull(t, "t"); cause != null; cause = cause.getCause()) {
            if (cause instanceof StatusException) {
                StatusException e = (StatusException)cause;
                return StatusProto.fromStatusAndTrailers(e.getStatus(), e.getTrailers());
            }
            if (!(cause instanceof StatusRuntimeException)) continue;
            StatusRuntimeException e = (StatusRuntimeException)cause;
            return StatusProto.fromStatusAndTrailers(e.getStatus(), e.getTrailers());
        }
        return null;
    }

    public static com.couchbase.client.core.deps.com.google.rpc.Status fromStatusAndTrailers(Status status, @Nullable Metadata trailers) {
        com.couchbase.client.core.deps.com.google.rpc.Status statusProto;
        Preconditions.checkNotNull(status, "status");
        if (trailers != null && (statusProto = trailers.get(STATUS_DETAILS_KEY)) != null) {
            Preconditions.checkArgument(status.getCode().value() == statusProto.getCode(), "com.couchbase.client.core.deps.com.google.rpc.Status code must match gRPC status code");
            return statusProto;
        }
        Status.Builder statusBuilder = com.couchbase.client.core.deps.com.google.rpc.Status.newBuilder().setCode(status.getCode().value());
        if (status.getDescription() != null) {
            statusBuilder.setMessage(status.getDescription());
        }
        return statusBuilder.build();
    }
}

