/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.deps.org.xbill.DNS.dnssec;

import com.couchbase.client.core.deps.org.xbill.DNS.Name;
import com.couchbase.client.core.deps.org.xbill.DNS.RRSIGRecord;
import com.couchbase.client.core.deps.org.xbill.DNS.RRset;
import com.couchbase.client.core.deps.org.xbill.DNS.Record;
import com.couchbase.client.core.deps.org.xbill.DNS.dnssec.SecurityStatus;
import java.util.List;
import lombok.Generated;

class SRRset
extends RRset {
    private SecurityStatus securityStatus;
    private Name ownerName;

    public SRRset() {
        this.securityStatus = SecurityStatus.UNCHECKED;
    }

    public SRRset(Record r) {
        super(r);
        this.securityStatus = SecurityStatus.UNCHECKED;
    }

    public SRRset(RRset r) {
        super(r);
        this.securityStatus = SecurityStatus.UNCHECKED;
    }

    public SRRset(SRRset r) {
        super(r);
        this.securityStatus = r.securityStatus;
        this.ownerName = r.ownerName;
    }

    public SecurityStatus getSecurityStatus() {
        return this.securityStatus;
    }

    public void setSecurityStatus(SecurityStatus status) {
        this.securityStatus = status;
    }

    public Name getSignerName() {
        List<RRSIGRecord> sigs = this.sigs();
        if (!sigs.isEmpty()) {
            return sigs.get(0).getSigner();
        }
        return null;
    }

    @Override
    public Name getName() {
        return this.ownerName == null ? super.getName() : this.ownerName;
    }

    public void setName(Name ownerName) {
        this.ownerName = ownerName;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SRRset)) {
            return false;
        }
        SRRset other = (SRRset)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SecurityStatus this$securityStatus = this.getSecurityStatus();
        SecurityStatus other$securityStatus = other.getSecurityStatus();
        if (this$securityStatus == null ? other$securityStatus != null : !((Object)((Object)this$securityStatus)).equals((Object)other$securityStatus)) {
            return false;
        }
        Name this$ownerName = this.ownerName;
        Name other$ownerName = other.ownerName;
        return !(this$ownerName == null ? other$ownerName != null : !((Object)this$ownerName).equals(other$ownerName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SRRset;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        SecurityStatus $securityStatus = this.getSecurityStatus();
        result = result * 59 + ($securityStatus == null ? 43 : ((Object)((Object)$securityStatus)).hashCode());
        Name $ownerName = this.ownerName;
        result = result * 59 + ($ownerName == null ? 43 : ((Object)$ownerName).hashCode());
        return result;
    }
}

