/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.env;

import com.couchbase.client.core.error.InvalidArgumentException;

public class InvalidPropertyException
extends InvalidArgumentException {
    private final String propertyName;
    private final String propertyValue;

    private InvalidPropertyException(String propertyName, String propertyValue, Throwable cause) {
        super("Failed to apply environment config property '" + propertyName + "' with value '" + propertyValue + "'. " + cause.getMessage(), cause, null);
        this.propertyName = propertyName;
        this.propertyValue = propertyValue;
    }

    public static InvalidPropertyException forProperty(String propertyName, String propertyValue, Throwable cause) {
        return new InvalidPropertyException(propertyName, propertyValue, cause);
    }

    public String propertyName() {
        return this.propertyName;
    }

    public String propertyValue() {
        return this.propertyValue;
    }
}

