/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.error;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.context.ErrorContext;
import com.couchbase.client.core.logging.RedactableArgument;
import java.util.Objects;
import reactor.util.annotation.Nullable;

@Stability.Volatile
public class BucketExistsException
extends CouchbaseException {
    private final String bucketName;

    @Stability.Internal
    public BucketExistsException(String bucketName, @Nullable ErrorContext context) {
        super("Bucket [" + RedactableArgument.redactMeta(bucketName) + "] already exists.", context);
        this.bucketName = Objects.requireNonNull(bucketName);
    }

    public static BucketExistsException forBucket(String bucketName) {
        return new BucketExistsException(bucketName, null);
    }

    public String bucketName() {
        return this.bucketName;
    }
}

