/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.error;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.logging.RedactableArgument;
import java.util.Objects;

@Stability.Volatile
public class GroupNotFoundException
extends CouchbaseException {
    private final String groupName;

    public GroupNotFoundException(String groupName) {
        super("Group [" + RedactableArgument.redactSystem(groupName) + "] not found.");
        this.groupName = Objects.requireNonNull(groupName);
    }

    public static GroupNotFoundException forGroup(String groupName) {
        return new GroupNotFoundException(groupName);
    }

    public String groupName() {
        return this.groupName;
    }
}

